<?xml version="1.0"?>
<!--
    blocks.mod.xsl - displays, examples. quotations, and such.
	$Id: blocks.mod.xsl,v 1.17 2005/03/30 17:20:05 Bronger Exp $	

    Copyright © 2004, 2005 Torsten Bronger <bronger@physik.rwth-aachen.de>.

    This file is part of texi2latex.

    texi2latex is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free
    Software Foundation; either version 2 of the License, or (at your option)
    any later version.

    texi2latex is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with texi2latex; if not, write to the Free Software Foundation, Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA
-->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- FixMe: The definition of all the "block" (or "verbatim") environments may
     be not robust enough.  It is not wise to nest them.  This is not
     explicitly allowed in the Texinfo specification, however, I think it
     should be made possible (and it is possible to do so). -->

<!-- FixMe: Maybe it's bad to treat <copying> the same as <quotation>.  At
     least, it must be tested. -->

<xsl:template match="quotation | copying">
  <xsl:text>\begin{quote}</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>\end{quote}</xsl:text>
</xsl:template>

<!-- "verbatim" needs very special treatment: First, it has a global
     \xobeylines, then, it has a special markup command, and last but not
     least, no further \xobeylines are deployed (in text-nodes.mod.xsl).
     However, all this uglyness is put into the {texiVerbatim} environment.
     -->

<xsl:template match="verbatim">
  <xsl:text>\begin{texiVerbatim}</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>\end{texiVerbatim}</xsl:text>
</xsl:template>

<!-- If a @list environment contains markup, it is treated like @example.
     Thus, there won't be any syntax highlighting.  This is not very nice, but
     the alternative is to switch off syntax highlighting always. -->

<xsl:template match="example | lisp" name="process-example">
  <xsl:text>\begin{display}\ttfamily </xsl:text>
  <xsl:apply-templates/>
  <xsl:text>\end{display}</xsl:text>
</xsl:template>

<xsl:template match="display" name="process-display">
  <xsl:text>\begin{display}\relax </xsl:text>
  <xsl:apply-templates/>
  <xsl:text>\end{display}</xsl:text>
</xsl:template>

<!-- At the moment any explicit formatting in @lisp doesn't work, see above.
     But at least this could be fixed manually for any occuring formatting
     command.  Not elegant, but sensible I think.

     Alternatively, it may be possible to tweak the listings package that it
     interprets all LaTeX commands as is.  -->

<xsl:template match="lisp[not(*)]" name="process-pure-lisp">
  <xsl:text>\begin{lstlisting}[language=lisp]&#10;</xsl:text>
  <!-- Avoid text node delimiters. -->
  <xsl:value-of select="."/>
  <xsl:text>\end{lstlisting}</xsl:text>
</xsl:template>

<xsl:template match="format" name="process-format">
  <xsl:text>\begin{display}[0pt]</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>\end{display}</xsl:text>
</xsl:template>

<!-- Small veriants -->

<xsl:template match="smallexample | smalllisp">
  <xsl:text>\begin{small}</xsl:text>
  <xsl:call-template name="process-example"/>
  <xsl:text>\end{small}</xsl:text>
</xsl:template>

<xsl:template match="smalllisp[not(*)]">
  <xsl:text>\begin{small}</xsl:text>
  <xsl:call-template name="process-pure-lisp"/>
  <xsl:text>\end{small}</xsl:text>
</xsl:template>

<xsl:template match="smalldisplay">
  <xsl:text>\begin{small}</xsl:text>
  <xsl:call-template name="process-display"/>
  <xsl:text>\end{small}</xsl:text>
</xsl:template>

<xsl:template match="smallformat">
  <xsl:text>\begin{small}</xsl:text>
  <xsl:call-template name="process-format"/>
  <xsl:text>\end{small}</xsl:text>
</xsl:template>

<!-- Flushleft and flushright are not yet supported by makeinfo.  Whyever. -->

<xsl:template match="flushleft">
  <xsl:text>\begin{flushleft}&#10;</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>&#10;\end{flushleft}</xsl:text>
</xsl:template>

<xsl:template match="flushright">
  <xsl:text>\begin{flushright}&#10;</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>&#10;\end{flushright}</xsl:text>
</xsl:template>

<!-- Maybe the following realisation of @exdent is too fragile, I don't know.
     But it seems to work. -->

<xsl:template match="exdent">
  <xsl:text>\par\hspace*{-\standardmargin}</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>\par</xsl:text>
</xsl:template>

<!-- The following code is stolen from texinfo.tex and translated to LaTeX.  It
     is important not to insert spurious empty lines here, therefore I don't
     use XML comments, because we are in an obeyspaces environment. -->

<xsl:template match="group">
  <xsl:text>\begin{samepage}</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>\end{samepage}</xsl:text>
</xsl:template>

<!-- This is not very clean, but it looks rather nice.  I hope that this
     doesn't destroy the original line breaks. -->

<xsl:template match="cartouche">
  <xsl:text>&#10;\begin{center}\shadowbox{\hbox to \hsize{\begin{minipage}{\hsize}</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>\end{minipage}\hss}}\end{center}&#10;</xsl:text>
</xsl:template>

<xsl:template match="center">
  <xsl:text>\par\noindent\centerline{</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>}\par</xsl:text>
</xsl:template>

</xsl:stylesheet>
