<?xml version="1.0"?>
<!--
    preamble.mod.xsl - template for root element with LaTeX preamble.
        $Id: preamble.mod.xsl,v 1.29 2005/04/05 12:43:34 Bronger Exp $  

    Copyright © 2004, 2005 Torsten Bronger <bronger@physik.rwth-aachen.de>.

    This file is part of texi2latex.

    texi2latex is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free
    Software Foundation; either version 2 of the License, or (at your option)
    any later version.

    texi2latex is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with texi2latex; if not, write to the Free Software Foundation, Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA
-->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- The following command line option holds the LaTeX document class.  Default
     is "book".  -->

<xsl:param name="document-class" select="'book'"/>

<!-- The following command line option holds a comma separated list of further
     global options. -->

<xsl:param name="global-options"/>

<!-- The root template: Here I create the complete preamble and the {document}
     environment. -->

<xsl:template match="texinfo">
  <xsl:text>\documentclass[</xsl:text>
  <xsl:value-of select="$document-language"/>
  <xsl:if test="$global-options != ''">
    <xsl:text>,</xsl:text>
    <xsl:value-of select="$global-options"/>
  </xsl:if>
<xsl:text>]{</xsl:text>
  <xsl:value-of select="$document-class"/>
  <xsl:text>}

\newdimen{\standardmargin}  \setlength{\standardmargin}{15pt}
\newdimen{\tableindent}     \setlength{\tableindent}{50pt}
\newbox\ItemBox

\setcounter{secnumdepth}{5}       <!-- If a section is not stared, it must always -->
\setcounter{tocdepth}{5}          <!-- have a number.                             -->

\usepackage[latin1]{inputenc}     <!-- Necessary for the use of tbrplent -->
\usepackage[T1]{fontenc}
\usepackage{textcomp}
\usepackage{babel}
</xsl:text>
  <xsl:call-template name="insert-quotation-marks-commands"/>
  <xsl:if test="$multitables">
    <xsl:call-template name="insert-preamble-multitable"/>
  </xsl:if>
  <xsl:if test="//cartouche">
    <xsl:call-template name="insert-preamble-cartouche"/>
  </xsl:if>
  <xsl:if test="//image">
    <xsl:call-template name="insert-preamble-graphics"/>
  </xsl:if>
  <xsl:text>\usepackage</xsl:text>
  <xsl:if test="$document-language-roughly != $document-language">
    <xsl:value-of select="concat('[',$document-language-roughly,']')"/>
  </xsl:if>
  <xsl:text>{varioref}         <!-- varioref only gets an explicit language if
                                    different from global language -->
</xsl:text>
  <xsl:if test="$syntax-highlighting != 'no' and
                (//*[self::lisp[not(*)] or self::smalllisp[not(*)]])">
    <xsl:call-template name="insert-preamble-listings"/>
  </xsl:if>
  <xsl:text>

<!-- \lb is "linebreak".  It is meant as an alternative to "\\" in {display}
     environments, because I want to avoid the "There's no line here to end"
     error message of LaTeX.  I just want LaTeX to ignore the \lb if we are in
     vertical mode.  -->

\newcommand{\lb}{\ifvmode\else\unskip\relax\nobreak\hfil\break\fi}


<!-- This is the environment that is used for all verbatim-like environments in
     Texinfo.  See blocks.mod.xsl for the application of this environment.

     I redefine ~ in order to avoid space-collapsing at the beginning of a line
     (where we are still in vertical mode).  And I redefine \\ because I need
     the error messages in vertical mode supressed.  I can't generate \lb
     automatically because the \\ are generated by tbrplent.  -->

\newenvironment{display}[1][\standardmargin]%
                       {\begingroup\def~{\mbox{ }}\let\\=\lb
                        \list{}{\listparindent0pt  \itemindent0pt
                        \rightmargin0pt    \leftmargin#1}%
                \item}
               {\endlist\endgroup}

<!-- All I change here is are the margins, which are set to \standardmargin.
-->

\renewenvironment{quote}
                 {\list{}{\leftmargin\standardmargin\rightmargin\leftmargin}%
                  \item\relax}
                 {\endlist}

<!-- The following macro solves a very serious LaTeX problem: preventing page
     breaks immediately before a list.  I need that in order to avoid page
     breaks between a definition term and a definition item.  Taken from Donald
     Arsenau in <news:9SEP199916335919@erich.triumf.ca>. -->

\makeatletter
\newcommand\Nopagebreak{\let\if@nobreak\iftrue \nopagebreak}
\makeatother

<!-- All hooks of texi2latex.  Use them for customisation. -->

<!-- First, the inline hooks. -->

\newcommand{\tabletermHook}[1]{#1}
<!-- The following commands are called "indicating" in the Texinfo manual.  -->
\newcommand{\codeHook}[1]{\mbox{\ttfamily #1}}
\newcommand{\kbdHook}[1]{\mbox{\ttfamily\slshape #1}}
<!-- FixMe: This one should optionally make use of the keystroke package. -->
\newcommand{\keyHook}[1]{{\fboxsep2pt\fbox{\sffamily\footnotesize #1}}}
\newcommand{\sampHook}[1]{\lnqHook\texttt{#1}\rnqHook}
\newcommand{\verbHook}[1]{\mbox{\ttfamily #1}}
\newcommand{\varHook}[1]{\mbox{\slshape #1}}
\newcommand{\envHook}[1]{\mbox{\ttfamily #1}}
\newcommand{\fileHook}[1]{\lnqHook\texttt{#1}\rnqHook}
\newcommand{\commandHook}[1]{\mbox{\ttfamily #1}}
\newcommand{\optionHook}[1]{\lnqHook\mbox{\ttfamily #1}\rnqHook}
\newcommand{\dfnHook}[1]{\emph{#1}}
\newcommand{\citeHook}[1]{\textit{#1}}
\newcommand{\abbrevwordHook}[1]{#1}
\newcommand{\abbrevdescHook}[1]{ (#1)}
\newcommand{\acronymwordHook}[1]{\mbox{#1}}
\newcommand{\acronymdescHook}[1]{\footnote{#1}}
\newcommand{\urlHook}[1]{#1}
\newcommand{\emailHook}[1]{#1}
<!-- The following commands are called "emphasizing" in the Texinfo
     manual. -->
\newcommand{\emphHook}[1]{\emph{#1}}
\newcommand{\strongHook}[1]{\textbf{#1}}
\newcommand{\scHook}[1]{\textsc{#1}}
\newcommand{\slantedHook}[1]{\textsl{#1}}
\newcommand{\sansserifHook}[1]{\textsf{#1}}
\newcommand{\iHook}[1]{\textit{#1}}
\newcommand{\bHook}[1]{\textbf{#1}}
\newcommand{\tHook}[1]{\texttt{#1}}
\newcommand{\rHook}[1]{\textrm{#1}}
\newcommand{\dmnHook}[1]{\,\mbox{#1}}
\newcommand{\mathHook}[1]{\ensuremath{#1}}
\newcommand{\footnoteHook}[1]{\footnote{#1}}

<!-- And now for the block hooks. -->

\newenvironment{quotationHook}{\begin{quote}}{\end{quote}}
\newenvironment{copyingHook}{\begin{quote}}{\end{quote}}
\newenvironment{verbatimHook}{\begin{display}[0pt]\ttfamily}{\end{display}}
\newenvironment{exampleHook}{\begin{display}\ttfamily}{\end{display}}
\newenvironment{lispHook}{\begin{display}\ttfamily}{\end{display}}
\newenvironment{displayHook}{\begin{display}\relax}{\end{display}}
\newenvironment{formatHook}{\begin{display}[0pt]}{\end{display}}
<!-- The small variants. -->
\newenvironment{smallexampleHook}{\begin{small}\begin{exampleHook}}%
    {\end{exampleHook}\end{small}}
\newenvironment{smalldisplayHook}{\begin{small}\begin{displayHook}}%
    {\end{displayHook}\end{small}}
\newenvironment{smallformatHook}{\begin{small}\begin{formatHook}}%
    {\end{formatHook}\end{small}}
\newenvironment{smalllispHook}{\begin{small}\begin{lispHook}}%
    {\end{lispHook}\end{small}}
<!-- Further displays -->
\newenvironment{flushleftHook}{\begin{flushleft}}{\end{flushleft}}
\newenvironment{flushrightHook}{\begin{flushright}}{\end{flushright}}
\newenvironment{groupHook}{\begin{samepage}}{\end{samepage}}
<!-- cartouche is not very clean, but it looks rather nice.  I hope that this
     doesn't destroy the original line breaks. -->
\newenvironment{cartoucheHook}{\begin{center}\shadowbox\bgroup
    \hbox to \hsize\bgroup\begin{minipage}{\hsize}}%
    {\end{minipage}\hss\egroup\egroup\end{center}}
<!-- This is the only block hook that's not an environement.  Instead, it looks
     like the inline hooks.  However, it's formatted as a block, so it belongs
     here. -->
\newcommand{\centerHook}[1]{\centerline{#1}}


<!-- The definitionitem environment is used for both the items of a definition
     command and for the items in two-column tables. -->

\newenvironment{definitionitem}[1][\standardmargin]
               {\list{}{\listparindent0pt  \itemindent0pt
                        \rightmargin0pt    \leftmargin#1}%
                \item\removelastskip\relax}
               {\endlist}

\sloppy               <!-- Is by far less harmful than its reputation -->
\hbadness20000

</xsl:text>
  <!-- $index-available is defined in index.mod.xsl -->
  <xsl:if test="$index-available">
    <xsl:call-template name="insert-preamble-index"/>
  </xsl:if>
  <xsl:text>

<!-- This is the inclusion of hyperref.  Note that it also works if you use
     "ordinary" LaTeX to produce a PDF.  Character protruding via pdfcprot is
     only used if available.  I include all meta-info here.  I use the very
     first paragraphh for the "subject", which may be a stupid thing. -->

\PassOptionsToPackage{hyphens}{url}
\newcommand{\xhyphen}{\discretionary{\char127}{}{-}}
\IfFileExists{pdfcprot.sty}{\usepackage[activate]{pdfcprot}}{}
\usepackage[%&#10;</xsl:text>
  <xsl:text>  pagebackref=true,pdfstartview=FitH,&#10;</xsl:text>
  <xsl:text>  pdfcreator={texi2latex + LaTeX with hyperref package},&#10;</xsl:text>
  <xsl:text>  pdfpagelayout=OneColumn,&#10;</xsl:text>
  <xsl:text>  bookmarks=true,bookmarksopen=false,</xsl:text>
  <xsl:text>  colorlinks,pdfpagelabels=true,&#10;</xsl:text>
  <xsl:text>  draft=false,breaklinks=true,plainpages=false]{hyperref}[2000/05/08]</xsl:text>
  <xsl:variable name="authors">
    <xsl:for-each select="//author">
      <xsl:value-of select="string(.)"/>
      <xsl:if test="position() != last()">
        <xsl:text>, </xsl:text>
      </xsl:if>
    </xsl:for-each>
  </xsl:variable>
  <xsl:text>  \hypersetup{%&#10;</xsl:text>
  <xsl:value-of select="concat('    pdftitle={',/texinfo/settitle,'},&#10;')"/>
  <xsl:value-of select="concat('    pdfsubject={',/texinfo/para[1],'},&#10;')"/>
  <xsl:value-of select="concat('    pdfauthor={',$authors,'}')"/>
  <xsl:text>&#10;  }&#10;</xsl:text>
  <xsl:text>\urlstyle{rm}
</xsl:text>
  <xsl:if test="//float">
    <xsl:call-template name="insert-preamble-float"/>
  </xsl:if>
  <xsl:text>

<!-- The following is needed for the (...) parameter in \section etc commands,
     however, it is not really used so far.  See structuring.mod.xsl for
     further details. -->

\usepackage{hypbmsec}

<!-- This is the most convenient way of customising texi2latex.  Just create a
     file in the local directory with the same name as your document but the
     suffix "-t2l.cfg".  Additionally, you can put a global texi2latex.cfg
     somewhere where LaTeX finds it.  However, definitions in the local file
     have higher priority. -->

\InputIfFileExists{texi2latex.cfg}%
  {\message{Loading global configuration file texi2latex.cfg}}{}
\InputIfFileExists{\jobname-t2l.cfg}%
  {\message{Loading local configuration file \jobname-t2l.cfg}}{}

<!-- The rest is very straightforward. -->

\begin{document}
</xsl:text>
  <xsl:apply-templates select="titlepage"/>
  <xsl:apply-templates select="contents | node"/>
  <xsl:text>&#10;\end{document}&#10;&#10;</xsl:text>
</xsl:template>


<!-- The following routines make it possible to have a minimal preamble, i.e. a
     preamble that doesn't include packages that aren't actually used.  Above
     in the root tamplate I test for the respective element, and if it exists,
     one of the following routines is called. -->

<xsl:template name="insert-preamble-listings">
  <!-- So far, listings is only used for Lisp source code.  FixMe: It should only
       be loaded when necessary. -->
  <xsl:text>\usepackage{listings}
<!-- Sensible listings settings: Typewriter font, bold keywords. -->
\lstset{basicstyle=\ttfamily,keywordstyle=\bfseries,extendedchars=true,xleftmargin=\standardmargin}
</xsl:text>
</xsl:template>

<xsl:template name="insert-preamble-graphics">
  <xsl:text>\usepackage{graphicx}&#10;</xsl:text> 
</xsl:template>

<!-- Now for the float management.

     "figure" and "table" are pre-defined environments that I don't override.
     I only adjust default placement.  Moreover, I define a fall-back
     environement "miscellaneous" that is used everywhere when no explicit
     float typ is specified. -->

<xsl:template name="insert-preamble-float">
  <xsl:text>
\usepackage{float}
\floatplacement{figure}{tb}
\floatplacement{table}{tb}
\newfloat{miscellaneous}{tb}{miscellaneous}
\makeatletter
<!-- The following line gets rid of the space before the float number (the
     label "Miscellaneous" is avoided anyway).  Thanks to Axel Sommerfeld. -->
\def\fnum@miscellaneous{\themiscellaneous}
<!-- I need a \listof without heading -->
\newcommand*{\nakedlistof}[2]{%
  \@ifundefined{ext@#1}{\float@error{#1}}{%
    \@namedef{l@#1}{\@dottedtocline{1}{1.5em}{2.3em}}%
%    \float@listhead{#2}%   This one is the one that must be commented out
    \begingroup\setlength{\parskip}{\z@}%
      \@starttoc{\@nameuse{ext@#1}}%
    \endgroup}}
\makeatother
</xsl:text>
  <!-- The following routine is defined in images-floats.mod.xsl -->
  <xsl:call-template name="insert-float-styles"/>
  <xsl:text>

<!-- Also caption2 is only necessary when we have floats in the Texinfo
     documents.  FixMe: Eventually we should switch to caption v3.  However,
     this would make a fresh listings version necessary and therefore I'm
     reluctant to do so.  However, I would make things a little bit
     cleaner. -->

\usepackage[</xsl:text>
  <xsl:if test="$multitables">
    <xsl:text>longtable,</xsl:text>
  </xsl:if>
  <xsl:text>float]{caption2}
</xsl:text>
</xsl:template>

<xsl:template name="insert-preamble-multitable">
  <xsl:text>\usepackage{longtable,booktabs}&#10;</xsl:text>  
</xsl:template>

<xsl:template name="insert-preamble-cartouche">
  <xsl:text>\usepackage{fancybox}&#10;</xsl:text>  
</xsl:template>

<xsl:template name="insert-preamble-index">
  <xsl:text>
\usepackage{index,multicol}
\makeatletter
<!-- I re-define the {theindex} environment so that it does not produce a
     (chapter) heading. -->
\renewenvironment{theindex}
               {\begin{multicols}{2}
                \thispagestyle{plain}\parindent\z@
                \parskip\z@ \@plus .3\p@\relax
                \columnseprule \z@
                \columnsep 35\p@
                \let\item\@idxitem}
               {\end{multicols}}
\makeatother

<!-- Here I write the file makeindex.bat to the current directory (if it is
     already there, it is overwritten).  It contains the commands for creating
     the indices.  FixMe: At the moment this only works for Linux, because
     Windows doesn't recognise the hash signs as comment introducers. -->

\immediate\openout15=makeindex.bat
{\catcode`\#11\immediate\write15{#! /bin/sh^^J%
# This in an auto-generated file. \space Do not edit it.^^J^^J%
# You can produce all indices with 'bash makeindex.bat' with Linux^^J%
# or just 'makeindex.bat' with Windows.^^J}}
</xsl:text>
  <!-- This is defined in index.mod.xsl -->
  <xsl:call-template name="insert-index-types"/>
  <xsl:text>
\immediate\closeout15
</xsl:text>  
</xsl:template>

<!-- This becomes a glibal variable - in contrast to all the other
     is-element-present tests - because it is used in *two* places. -->

<xsl:variable name="multitables" select="//multitable"/>

</xsl:stylesheet>
