<?xml version="1.0"?>
<!--
    lists.mod.xsl - itemizations enumerations, and two-column tables.
	$Id: lists.mod.xsl,v 1.4 2005/01/02 14:41:26 Bronger Exp $	

    Copyright © 2004, 2005 Torsten Bronger <bronger@physik.rwth-aachen.de>.

    This file is part of texi2latex.

    texi2latex is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free
    Software Foundation; either version 2 of the License, or (at your option)
    any later version.

    texi2latex is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with texi2latex; if not, write to the Free Software Foundation, Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA
-->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Itemizations and enumerations -->

<xsl:template match="itemize">
  <xsl:text>\begin{itemize}</xsl:text>
  <xsl:apply-templates select="item"/>
  <xsl:text>\end{itemize}</xsl:text>
</xsl:template>

<xsl:template match="enumerate">
  <xsl:text>\begin{enumerate}</xsl:text>
  <xsl:apply-templates select="item"/>
  <xsl:text>\end{enumerate}</xsl:text>
</xsl:template>

<xsl:template match="enumerate/item | itemize/item">
  <xsl:text>\item</xsl:text>
  <xsl:if test="parent::itemize">
    <xsl:apply-templates select="preceding-sibling::itemfunction"/>
  </xsl:if>
  <xsl:apply-templates/>
</xsl:template>

<!-- Here the bullets are created.  In the case of real bullets this is rather
     redundant, but I am to lazy to change that.  Besides, I don't think that
     it is necessary. -->

<xsl:template match="itemfunction">
  <xsl:text>[{</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>}]</xsl:text>
</xsl:template>

<!-- Two-column tables, which are called "descriptions" in LaTeX.  For real
     tables, see the multicolumn tables in tables.mod.xsl.

     In the original Texinfo, the tableterm and tableitem are not in the same
     line.  However, in LaTeX's description environment this is the case, and
     I like it this way, so I don't change it here. -->

<xsl:template match="table">
  <xsl:text>\begin{description}</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>\end{description}</xsl:text>
</xsl:template>

<xsl:template match="tableitem">
  <xsl:text>\item</xsl:text>
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="tableterm">
  <xsl:text>[{</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>}]</xsl:text>
</xsl:template>

<xsl:template match="tableitem/item">
  <xsl:text> </xsl:text>
  <xsl:apply-templates/>
</xsl:template>

<!-- Paras in items must carry their \par *afterwards*.  (This may be
     reasonable for all cases, but I don't care.) -->

<xsl:template match="item/para">
  <xsl:apply-templates/>
  <xsl:text>\par </xsl:text>
</xsl:template>


</xsl:stylesheet>
