<?xml version="1.0"?>
<!--
    preamble.mod.xsl - template for root element with LaTeX preamble.
	$Id: preamble.mod.xsl,v 1.4 2005/01/04 11:02:56 Bronger Exp $	

    Copyright © 2004, 2005 Torsten Bronger <bronger@physik.rwth-aachen.de>.

    This file is part of texi2latex.

    texi2latex is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free
    Software Foundation; either version 2 of the License, or (at your option)
    any later version.

    texi2latex is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with texi2latex; if not, write to the Free Software Foundation, Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA
-->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- The root template: Here I create the complete preamble and the {document}
     environment. -->

<xsl:template match="texinfo">
  <xsl:text>\documentclass[</xsl:text>
  <xsl:value-of select="$document-language"/>
<xsl:text>]{book}

\newdimen{\standardmargin}
\setlength{\standardmargin}{15pt}
\setcounter{secnumdepth}{5}       % If a section is not stared, it must always
\setcounter{tocdepth}{5}          % have a number.

\usepackage[latin1]{inputenc}     % Necessary for the use of tbrplent
\usepackage[T1]{fontenc}
\usepackage{mathpple}
\usepackage[scaled=0.9]{helvet}
\usepackage{courier}
\usepackage{babel}
\usepackage{longtable,booktabs,graphicx}  % FixMe: Should only be loaded when necessary
\usepackage</xsl:text>
  <xsl:if test="$document-language-roughly != $document-language">
    <xsl:value-of select="concat('[',$document-language-roughly,']')"/>
  </xsl:if>
  <xsl:text>{varioref}            % varioref only gets an explicit language if
                                  % different from global language

% So far, listings is only used for Lisp source code.  FixMe: It should only
% be loaded when necessary.
\usepackage{listings}
% Sensible listings settings: Typewriter font, bold keywords.
\lstset{basicstyle=\ttfamily,keywordstyle=\bfseries,extendedchars=true,xleftmargin=\standardmargin}

% And now for a rather sub-optimal part, namely the processing of blocks with
% by and large verbatim material:  @display, @format, @verbatim etc.  I can't
% use listings for this because it doesn't allow for LaTeX macros; instead, it
% would print them as is.
%
% The command \xobeyspace will be executed at the beginning of every text node
% in a verbatim environment and kept local to this text node.  So it will
% *not* be executed only once at the beginning of the environment.

{\catcode`\^^M\active \endlinechar=-1 %
\gdef\xobeylines{\parskip0pt\catcode`\^^M\active
    \def^^M{\endgraf\futurelet\next\maybeskip}
    \def\maybeskip{\ifx\next^^M \vskip\baselineskip \fi}}
}

\newcommand{\xobeyspaces}{\frenchspacing\obeyspaces}

% This is the environment that is used for all verbatim-like environments in
% Texinfo.  See blocks.mod.xsl for the application of this environment.

\newenvironment{display}{\begingroup\parindent0pt\par\vspace{2ex}\hsize500cm\xobeylines}%
  {\endgroup\vspace{2ex}}

\sloppy               % Is by far lees harmful than its reputation
\hbadness20000

% The index

% FixMe: The following should only be used if an index is actuall used.

\usepackage{index,multicol}
\makeatletter
% I re-define the {theindex} environment so that it does not produce a
% (chapter) heading.
\renewenvironment{theindex}
               {\begin{multicols}{2}
                \thispagestyle{plain}\parindent\z@
                \parskip\z@ \@plus .3\p@\relax
                \columnseprule \z@
                \columnsep 35\p@
                \let\item\@idxitem}
               {\end{multicols}}
\makeatother
% Here I write the file makeindex.bat to the current directory (if it is
% already there, it is overwritten).  It contains the commands for creating
% the indices.  FixMe: At the moment this only works for Linux, because
% Windows doesn't recognise the hash signs as comment introducers.
\immediate\openout15=makeindex.bat
{\catcode`\#11\immediate\write15{#! /bin/sh^^J%
# This in an auto-generated file. \space Do not edit it.^^J^^J%
# You can produce all indices with 'bash makeindex.bat' with Linux^^J%
# or just 'makeindex.bat' with Windows.^^J}}
</xsl:text>
  <!-- This is defined in index.mod.xsl -->
  <xsl:call-template name="insert-index-types"/>
  <xsl:text>
\immediate\closeout15

% This is the inclusion of hyperref.  Note that it also works if you use
% "ordinary" LaTeX to produce a PDF.  Character protruding via pdfcprot is
% only used if available.  I include all meta-info here.  I use the very first
% paragraphh for the "subject", which may be a stupid thing.

\PassOptionsToPackage{hyphens}{url}
\newcommand{\xhyphen}{\discretionary{\char127}{}{-}}
\IfFileExists{pdfcprot.sty}{\usepackage[activate]{pdfcprot}}{}
\usepackage[%&#10;</xsl:text>
  <xsl:text>  pagebackref=true,pdfstartview=FitH,&#10;</xsl:text>
  <xsl:text>  pdfcreator={texi2latex + LaTeX with hyperref package},&#10;</xsl:text>
  <xsl:text>  pdfpagelayout=OneColumn,&#10;</xsl:text>
  <xsl:text>  bookmarks=true,bookmarksopen=false,</xsl:text>
  <xsl:text>  pdfpagelabels=true,&#10;</xsl:text>
  <xsl:text>  draft=false,plainpages=false]{hyperref}[2000/05/08]</xsl:text>
  <xsl:text>  \hypersetup{%&#10;</xsl:text>
  <xsl:value-of select="concat('    pdftitle={',/texinfo/settitle,'},&#10;')"/>
  <xsl:value-of select="concat('    pdfsubject={',/texinfo/para[1],'},&#10;')"/>
  <xsl:value-of select="concat('    pdfauthor={',//author,'}')"/>
  <xsl:text>&#10;  }&#10;</xsl:text>
  <xsl:text>\urlstyle{rm}

% Now for the float management.  FixMe: This should only be included if floats
% are actually used.

% "figure" and "table" are pre-defined environments that I don't override.  I
% only adjust default placement.  Moreover, I define a fall-back environement
% "miscellaneous" that is used everywhere when no explicit float typ is
% specified.

\usepackage{float}
\floatplacement{figure}{tb}
\floatplacement{table}{tb}
\newfloat{miscellaneous}{tb}{miscellaneous}
\makeatletter
% The following line gets rid of the space before the float number (the label
% "Miscellaneous" is avoided anyway).  Thanks to Axel Sommerfeld.
\def\fnum@miscellaneous{\themiscellaneous}
% I need a \listof without heading
\newcommand*{\nakedlistof}[2]{%
  \@ifundefined{ext@#1}{\float@error{#1}}{%
    \@namedef{l@#1}{\@dottedtocline{1}{1.5em}{2.3em}}%
%    \float@listhead{#2}%   This one is commented out
    \begingroup\setlength{\parskip}{\z@}%
      \@starttoc{\@nameuse{ext@#1}}%
    \endgroup}}
\makeatother
</xsl:text>
  <!-- The following routine is defined in images-floats.mod.xsl -->
  <xsl:call-template name="insert-float-styles"/>
  <xsl:text>

% Also caption2 is only necessary when we have floats in the Texinfo
% documents.  FixMe: Eventually we should switch to caption v3.  However, this
% would make a fresh listings version necessary and therefor I'm reluctant to
% do so.  However, I would make thing a little bit cleaner.

\usepackage{caption2}

% The rest is very straightforward.

\begin{document}
</xsl:text>
  <xsl:apply-templates select="titlepage"/>
  <xsl:apply-templates select="contents | node"/>
  <xsl:text>&#10;\end{document}</xsl:text>
</xsl:template>

</xsl:stylesheet>
