/****************************************************************************
** Copyright (C) 2006  Xavier Cremaschi (omega.xavier@gmail.com)
** This file is part of teXswitcher.
** teXswitcher is a LaTeX document modifier.
**
** teXswitcher is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program; if not, write to the Free Software Foundation, Inc.,
** 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
****************************************************************************/


#ifndef _GUI_H_
#define _GUI_H_

#include <QMainWindow>
#include <QApplication>

#include <iostream>
using namespace std;



// declaration of needed types
class QAction;
class QVBoxLayout;
class QLabel;

class Node;
class TreeModel;
class QTreeView;

// a very simple graphical user interface
class Gui : public QMainWindow {

    Q_OBJECT

    private:
        static const string CTRL_PRESSED;
        static const string CTRL_RELEASED;
        static const string VERSION;
        
        
        Node*           root;
        TreeModel*      treemodel;
        QTreeView*      treeview;
        QAction*        saveAct; // keep a pointer on to enable/disable it
        QVBoxLayout*    layout;
        QLabel*         status_label;

        void keyPressEvent(QKeyEvent*);
        void keyReleaseEvent(QKeyEvent*);

    protected slots:
        // menu
        void openFile(void);
        void saveFile(void);

        // buttons
        void increase_selected_keyword(void);
        void decrease_selected_keyword(void);

    public:
        Gui(QApplication*);
        ~Gui();
};

#endif
