/****************************************************************************
** Copyright (C) 2006  Xavier Cremaschi (omega.xavier@gmail.com)
** This file is part of teXswitcher.
** teXswitcher is a LaTeX document modifier.
**
** teXswitcher is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program; if not, write to the Free Software Foundation, Inc.,
** 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
****************************************************************************/


#include "Keyword.h"

#include "KeywordSet.h"
#include "KeywordSetWithChapter.h"
#include "KeywordSetWithoutChapter.h"


KeywordSet* Keyword::ref = Keyword::without_chapter();


/**
 * It is hazardous to use static member variables in static member functions,
 * because you do not know if your variable is initialized BEFORE your function
 * 
 * Trick from faq-lite-c++ : replace variable by function like
 *          Foobar* variable() { static Foobar* f = new Foobar(); return f; }
 * Why ?
 * static local objects are build the first time (and only the first time) the
 * control stream process the declaration
 * So "static Foobar* f = new Foobar()" is executed only one time (the first
 * time the method is called). Each futur call will return the same object
 * (pointed by f)
 */
KeywordSet* Keyword::with_chapter(void) {
    static KeywordSet* with_chapter = new KeywordSetWithChapter();
    return with_chapter;
}

KeywordSet* Keyword::without_chapter(void) {
    static KeywordSet* without_chapter = new KeywordSetWithoutChapter();
    return without_chapter;
}






/*******************************************************
 * STATIC METHODS USED BY OTHER CLASSES OF teXswitcher *
 *******************************************************/
const int Keyword::NB_OF_KEYWORDS(void) {
    return Keyword::ref->get_nb_of_keywords();
}

const string Keyword::KEYWORD(int value) {
    return Keyword::ref->get_keyword(value);
}

const int Keyword::MIN_VALUE(void) {
    return Keyword::ref->get_min_value();
}

const int Keyword::MAX_VALUE(void) {
    return Keyword::ref->get_max_value();
}

const string Keyword::LATEX_DOCUMENT_FIRST_KEYWORD(void) {
    return Keyword::ref->get_latex_document_first_keyword();
}

const string Keyword::LATEX_DOCUMENT_LAST_KEYWORD (void) {
    return Keyword::ref->get_latex_document_last_keyword();
}

const int Keyword::value(string s) {
    return Keyword::ref->get_value(s);
}

void Keyword::use_chapter(bool use_chapter) {
    if(use_chapter) {
        Keyword::ref = Keyword::with_chapter();
    }
    else {
        Keyword::ref = Keyword::without_chapter();
    }
}
