/****************************************************************************
** Copyright (C) 2006  Xavier Cremaschi (omega.xavier@gmail.com)
** This file is part of teXswitcher.
** teXswitcher is a LaTeX document modifier.
**
** teXswitcher is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program; if not, write to the Free Software Foundation, Inc.,
** 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
****************************************************************************/


#ifndef _KEYWORD_H_
#define _KEYWORD_H_

// declaration of some useful types
class KeywordSet;

#include <iostream>
using namespace std;


/**
 * public static methods of this class are used by classes of teXswitcher as
 * soon as we require a piece of information about keywords
 */
class Keyword {
    private:
        static KeywordSet* ref;
        static KeywordSet* with_chapter(void);
        static KeywordSet* without_chapter(void);


    public:
        /*******************************************************
         * STATIC METHODS USED BY OTHER CLASSES OF teXswitcher *
         *******************************************************/
        static const int    NB_OF_KEYWORDS              (void);
        static const string KEYWORD                     (int);
        static const int    MIN_VALUE                   (void);
        static const int    MAX_VALUE                   (void);
        static const string LATEX_DOCUMENT_FIRST_KEYWORD(void);
        static const string LATEX_DOCUMENT_LAST_KEYWORD (void);
        static const int    value                       (string);
        static void         use_chapter                 (bool);
};
#endif
