/****************************************************************************
** Copyright (C) 2006  Xavier Cremaschi (omega.xavier@gmail.com)
** This file is part of teXswitcher.
** teXswitcher is a LaTeX document modifier.
**
** teXswitcher is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program; if not, write to the Free Software Foundation, Inc.,
** 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
****************************************************************************/


#ifndef _TREEMODEL_H_
#define _TREEMODEL_H_

#include <QAbstractItemModel>
#include <QModelIndex>
#include <QVariant>
#include <QStringList>
#include <QMimeData>

#include <iostream>
using namespace std;

class Node;

/**
 * TreeModel is used to make the relation between the QTreeView widget that
 * displays information, and the Node structure, that represents the tree of the
 * LaTeX document, created by the parser.
 */
class TreeModel : public QAbstractItemModel {

    Q_OBJECT

    private:
        static const QString MIME_TYPE;
        static Node* moving_node;

        Node *tree;
        bool is_recursive;

    public:
        TreeModel(Node*, QObject *parent = NULL);
        ~TreeModel();

        // When subclassing QAbstractItemModel, at the very least you must implement
        // index(), parent(), rowCount(), columnCount(), and data().
        QModelIndex index       (int, int, const QModelIndex& = QModelIndex()) const;
        QModelIndex parent      (const QModelIndex&)                           const;
        int         rowCount    (const QModelIndex& = QModelIndex())           const;
        int         columnCount (const QModelIndex& = QModelIndex())           const;
        QVariant    data        (const QModelIndex&, int)                      const;

        // for drag and drop
        Qt::ItemFlags   flags                   (const QModelIndex&)           const;
        Qt::DropActions supportedDropActions    (void)                         const;
        QMimeData*      mimeData                (const QModelIndexList&)       const;
        bool            dropMimeData            (const QMimeData*, Qt::DropAction, int, int, const QModelIndex&);
        QStringList     mimeTypes               (void)                         const;


        // for header's display
        QVariant        headerData  (int, Qt::Orientation, int = Qt::DisplayRole)   const;



        // not inherited methods
        void change(QModelIndex&, int);
        void act_on_subtree(bool);

};
#endif
