#!/usr/bin/env python
# -*- coding: utf8 -*-

##	Things Copyright(C) 2009 Donn.C.Ingle
##
##	Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##  This file is part of Things.
##
##  Things is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  Things is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with Things.  If not, see <http://www.gnu.org/licenses/>.

from Things.ThingsApp import *
from Things.Thinglets import *
import math

pi=math.pi
pi2=math.pi * 2

zeropos = Props()

def zerodot(ctx):
	ctx.set_source_rgb(1.0, 1.0, 0)
	ctx.rectangle(-44, -44, 44, 44)
	ctx.fill()

class Alien1( Thing ):
	def __init__ ( self ) :
		Thing.__init__ ( self, "One")
		self.keys("#", zeropos )
		
	def draw ( self, ctx, frame ):
		BOS['BUTTONS:redalien'].draw(ctx)

class Alien2( Thing ):
	def __init__ ( self) :
		start = Props ()
		Thing.__init__ ( self, "Two")
		self.keys("#",start )
		
	def draw ( self, ctx, frame ):
		BOS['BUTTONS:orangealien'].draw(ctx)	

class Alien3(Thing):
	def __init__ ( self) :
		Thing.__init__ ( self, "Three")
		self.keys( "#----#-----#",zeropos,Props(sx=4),zeropos )
		self.stops("...........^")	
	def draw ( self, ctx, frame ):
		BOS['BUTTONS:redalien'].draw(ctx)	

class Alien4(Thing):
	def __init__ ( self) :
		Thing.__init__ ( self, "Four")
		self.keys( "#-------------##",zeropos,Props(sx=0.4,sy=0.4),zeropos )
		self.stops("...............^")
	def draw ( self, ctx, frame ):
		BOS['BUTTONS:redalien'].draw(ctx)	

class Button(ButtonThing):
	"""ButtonThings cannot have keys()."""
	def __init__(self):
		ButtonThing.__init__(self,"testbutton")
		self.addStates( {"normal":A1,"over":A2,"down":A3,"up":A4} )
	def draw(self,ctx,fr):
		zerodot(ctx)
	def drawHitarea(self,ctx,frame):
		BOS['BUTTONS:alienhit'].draw(ctx)
	def onButtonOver(self):
		print "OVER FIRES"
	def onButtonOut(self):
		print "OUT FIRES"
	def onButtonDown(self):
		A3.goPlay(1)
		app.cursor("BOGOSITY")
		print "DOWN"
	def onButtonUp(self):
		A4.goPlay(1)
		A3.goStop(1)

		CircA.togLayer()
		print "UP"

class ButtonWrap(Thing):
	"""In order to control button placement, make a wrapper for a ButtonThing."""
	def __init__(self,x,y,BUTT):
		Thing.__init__(self,"wraps_a_button")
		self.keys("#",Props(x=x,y=y))
		self.add(BUTT)
		
class Circle(Thing):
	def __init__(self,x,y,col):
		Thing.__init__(self,"a_circle")
		self.keys("#",Props(x=x,y=y))
		self.col=col
		self.x=x
		self.y=y
		self.layer=0
	def togLayer(self):

		if self.layer == 20: 
			self.layer = 1
		else:
			self.layer = 20
		self.changeLayer(self.layer) #demo the changeLayer method

	def draw(self,ctx,fr):
		ctx.set_source_rgb(self.col[0],self.col[1],self.col[2])
		ctx.arc ( 0, 0, 20, 0, pi2)
		ctx.fill()

BOS = BagOfStuff()

BOS.add("button.stuff/buttons.svg", "BUTTONS")

app = AllThings ( 600, 600, speed = 20, title = "TEST",hideCursor=False)

# Make a bunch of aliens
A1 = Alien1()
A2 = Alien2()
A3 = Alien3()
A4 = Alien4()

# And a couple of circles
CircA = Circle(20,20,(1.0,0,0))
CircB = Circle(30,30,(0,1.0,0))

# now a Button: It will use the aliens as button states
B = Button()
# Now a wrapper, so we can position the button.
BW1 = ButtonWrap(-220,-20,B)

# Now we add the button and the circles to the app.
app.add(BW1)
app.add(CircA)
app.add(CircB,layer=10)


#app.showGrid()

app.comeToLife ( )


