from Things.ThingsApp import *
from Things.BoxOfTricks import *

class JiggleBall(Thing):
	def __init__(self ):
		Thing.__init__(self)
		self.keys  ( "#----------------#---------------#",
				Props(sy=0.9),Props(rot=6.28),Props(sy=0.9)
				)
	def draw(self,ctx,fr):
		bos["art:ball"].draw(ctx)

class Ball(Thing):
	def __init__(self ):
		Thing.__init__(self)
		self.keys  ( "#------------------#-------------------#", Props(sy=0.5),Props(),Props(sy=0.5))
		self.stops ( "                   ^" )
		self.labels( "                   ^","squishdown")

		self.add( JiggleBall() )
	def squish(self):
		self.goPlay("squishdown")

class Shadow(Thing):
	def __init__(self ):
		Thing.__init__(self)
		self.keys  ( ".#-------------------------#------------#", Props(a=0,sz=2),Props(),Props(a=0,sz=2))
		self.stops ( "^                          ^" )
		self.funcs ( "                                        ^", self.flip)
		self.labels( " ^                         ^", "darken","lighten")
		self.fd = fuzzydot()
	def draw(self,ctx,fr):
		self.fd.draw(ctx)
	def flip(self):
		self.parentThing.flip()

class Throw(FollowThing):
	def __init__(self ):
		FollowThing.__init__(self,"throw path")
		self.keys  (90, self.path, startAtFirstNode=False)
		ls = self.lifespan - 36
		self.funcs( "^" + " " * ls + "^                    ^            ^", 
				(self.tellshadow,"up"),(self.tellshadow,"down"),self.tellsquish,self.tellflip
				)
		self.ball=Ball()
		self.add( self.ball )

	def tellshadow(self, dir):
		if dir=="up":
			SHADOW.shadow.goPlay("lighten")
		else:
			SHADOW.shadow.goPlay("darken")
	def tellsquish(self):
		self.ball.squish()
	def tellflip(self):
		self.parentThing.flip()

	def path(self,ctx):
		bos["art:swoopy"].draw(ctx)

class TwoWay(Thing):
	def __init__(self ):
		Thing.__init__(self)
		self.keys  ( "##", Props(),Props(sx=-1))
		self.stops ( "^" )
		self.add( Throw() )
		self.f=False
	def flip(self):
		self.f = not(self.f)
		if self.f:
			self.goStop(2)
		else:
			self.goStop(1)

class TwoShadow(Thing):
	def __init__(self ):
		Thing.__init__(self)
		self.keys  ( "##", Props(),Props(sx=-1))
		self.stops ( "^" )
		self.shadow = Shadow()
		self.add( self.shadow, globalProps=Props(y=102,x=100,sy=0.2) )
		self.f = False	
	def flip(self):
		self.f = not(self.f)
		if self.f:
			self.goStop(2)
		else:
			self.goStop(1)

class Background(DrawThing):
	c=hexfloat("#5d6c53")
	b=hexfloat("#a7ac93")
	def draw(self,ctx,fr):
		ctx.set_source_rgb(*Background.b)
		ctx.paint()
		ctx.set_source_rgb(*Background.c)
		ctx.rectangle(-200,70,400,330)
		ctx.fill()
		

bos = BagOfStuff()
bos.add ( "tutorial.svg", "art")

app = AllThings ( 400, 400, speed = 20, title = "A Ball" )
app.add( Background() )
SHADOW=TwoShadow()
app.add( SHADOW )
app.add(TwoWay())

app.panZoom(True)
app.comeToLife ( )




