#!/usr/bin/env python
#
# Copyright (C) 2005, 2007, 2008 Nicolas Burrus
# This file is part of Tidydoc.
#
# Tidydoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Tidydoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Foobar; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import ac_config

from getopt import getopt
import os, shutil, sys

from td_config import config, read_config
import td_debug
import td_dsc
from td_tools import *

import td_upload

def print_help():
  sys.stderr.write(
"""Usage: td-reorganize-doc [options] dsc_file

  Options

  -c, --config configfile  Config file to use.
  -v, --version            Print version number.

Nicolas Burrus <nicolas.burrus@ensta.fr>
""")

def parse_command_line(argv):
  try: (options, args) =  getopt(argv[1:], "vc:", ["version", "config"])
  except:
    print_help()
    sys.exit(1)

  cmd_options = {}
  cmd_options['config_file'] = None

  for option in options:
    if option[0] == "-v" or option[0] == "--version":
      print "Tidydoc " + ac_config.version
      print "Nicolas Burrus <nicolas.burrus@ensta.fr>"
      sys.exit(0)
    if option[0] == "-c" or option[0] == "--config":
      cmd_options['config_file'] = option[1]

  if len(args) != 1:
    print_help()
    sys.exit(1)

  cmd_options['dsc_file'] = args[0]
  return cmd_options

def reorganize(dsc_file):
  doc_name = os.path.basename(td_dsc.doc_filename_from_dsc(dsc_file))

  ext = re.match('^.*\.(\w+)$', doc_name).group(1)
  tmp_doc_filename = os.tempnam() + '.' + ext
  tmp_dsc_filename = os.tempnam() + '.dsc'

  directories = [config['input_path']]
  for root, dirs, files in os.walk(config['input_path']):
    for name in dirs:
      if not os.path.exists(os.path.join(root, name, ".td_raw_dir")):
        directories.append(os.path.join(root, name))
  directories.sort()

  real_files = [] # document files which are not links
  real_dsc = None # description file which is not a link
  real_doc = None # doc file which is not a link
  for directory in directories:
    # Insert normal documents
    docs = glob(directory + '/' + doc_name)
    if len(docs) > 0:
      doc = docs[0]
      if os.path.islink(doc):
        files = glob(directory + '/' + re.sub('\.*$', '*', doc_name))
        for f in files:
          td_debug.debug("Removing `" + f + "'")
          os.remove(f)
      elif os.path.isfile(doc):
        files = glob(directory + '/' + re.sub('\.*$', '*', doc_name))
        real_doc = directory + '/' + doc_name
        real_dsc = directory + '/' + os.path.basename(dsc_file)
        real_files = files

  shutil.copyfile(real_dsc, tmp_dsc_filename)
  shutil.copyfile(real_doc, tmp_doc_filename)

  for f in real_files:
    td_debug.debug("Moving `" + f + "' to " + config['trash_path'])
    shutil.move(f, config['trash_path'])

  try:
    td_upload.upload(tmp_doc_filename, tmp_dsc_filename)
  except:
    sys.stderr.write(str(sys.exc_info()[0]) + "\n")
    print "Error: could not upload files."
    print "Document file is now : `" + tmp_doc_filename + "'"
    print "Description file is now : `" + tmp_dsc_filename + "'"
    print "Please upload them manually, with td-add-doc."
    raise Exception("Upload error.")

  os.remove(tmp_doc_filename)
  os.remove(tmp_dsc_filename)    

def __main__():
  cmd_options = parse_command_line(sys.argv)
  read_config(cmd_options['config_file'])
  reorganize(cmd_options['dsc_file'])

if __name__ == "__main__":
  __main__()
