#!/usr/bin/python

import cgi_config

import sys;
import os, os.path
import re
from urlparse import urlparse

import cgi;
import cgitb; cgitb.enable()

import ac_config
from td_config import config,read_config
import td_tools

print "Content-type: text/html; charset=UTF-8"
print

form = cgi.FieldStorage()

print "<html><body>"

def error(msg):
  print "<H1>Error</H1>"
  print msg

def get_url(url):
  if not re.match("^(ht|f)tps?://", url):
    error("Bad url.")
    return
  
  docname = os.path.basename(urlparse(url)[2])
  orig_doc_url = url
  orig_doc_path = "/tmp/tidydoc_" + docname

  try:
    td_tools.exec_commands('wget --no-check-certificate "%s" -O %s\n' % (orig_doc_url, orig_doc_path))
  except:
    error("Could not download `%s'\n" % orig_doc_url)
    return
  
  if not os.path.exists(orig_doc_path):
    error("`%s': not found.\n" % orig_doc_path)
    return

  return orig_doc_path

def get_file(fileitem):
  print "Document received"
  docname = form["document"].filename
  print docname
  docpath = "/tmp/" + docname
  output = open(docpath, "w")
  while 1:
    line = fileitem.file.readline(65535)
    if not line: break
    output.write(line)
  output.close()
  return docpath

def process():
  if not (form.has_key("document") and form.has_key("url")):
    error("Please fill in the document and url fields.")
    return

  url = form["url"].value
  if (url != ""):
    return get_url(url)

  fileitem = form["document"]
  if (fileitem.filename != ""):
    return get_file(fileitem)

  raise "You must provide an url or file."

def add_form(orig_doc_path):
    f = open(config['categories_path'], "r")
    categories = f.read()
    f.close()
    print orig_doc_path
    props = td_tools.guess_desc_from_doc(orig_doc_path)
    props['categories'] = categories
    props['url'] = form["url"].value
    props['nbrows'] = 80 + len(categories.splitlines())
    props['orig_doc_path'] = orig_doc_path
    print "<pre>" + str(props) + "</pre>"
    print """
<br>
<form action="get_dsc.cgi" method="post">
<input type="hidden" name="docpath" value="%(orig_doc_path)s"/>
<input type="submit" name="submit" value="Submit"/>
<br><br>
<TEXTAREA style="font-size: 10pt;" name="dsc" rows="%(nbrows)s" cols="80">
Title: %(title)s

%% One per line. End by the last name. eg: D. Knuth
Author: %(author)s

%% End it by the year. eg: Oct 2004
Date: %(date)s

%% Use short names. eg: siggraph
Conf: 

Pages: %(pages)s

Keywords: 

Link: %(url)s

%% Line breaks are taken into account.
Abstract: 

Visibility: public

Language: english

Bibtex type:
%% inproceedings
%% article
%% misc
%% inbook
%% book
%% phdthesis
%% techreport
%% incollection

Bibtex fields:
%%%% In Proceedings
%% booktitle = {}
%% volume = {}
%% number = {}
%% pages = {--}

%%%% Article
%% journal = {}
%% volume = {}
%% number = {}
%% pages = {--}

%%%% Misc
%% text = {}

%%%% In Book
%% chapter = {}
%% publisher = {}
%% pages = {--}

%%%% Book
%% publisher = {}

%%%% Phd Thesis
%% school = {}
%% month = {}

%%%% Technical Report
%% institution = {}

%%%% In Collection
%% booktitle = {}
%% editor = {}
%% publisher = {}
%% address = {}
%% pages = {--}
%% month = {}

Comment:

%% Uncomment as many as you want, links will be created.
Categories:
%(categories)s
</TEXTAREA>
</form>
""" % (props)

read_config(cgi_config.file)
orig_doc_path = process()
add_form(orig_doc_path)

print "</body></html>"
