#!/usr/bin/python

import cgi_config

import sys, os, os.path
import re
from urlparse import urlparse

import cgi;
import cgitb; cgitb.enable()

import ac_config
from td_config import config,read_config
import td_tools
import td_generate
import td_doctree
import td_html

print "Content-type: text/html; charset=UTF-8"
print

form = cgi.FieldStorage()

def error(msg):
  print "<H1>Error</H1>"
  print msg

def process():
  if not (form.has_key("pattern")):
    error("Bad post data.")
    return

  pattern = form["pattern"].value
  return (pattern)

def node_hash_matching_pattern(doctree, pattern, node_hash={}):
  for subdir in doctree.subdirs:
    node_hash_matching_pattern(subdir, pattern, node_hash)
  for doc in doctree.docs:
    exp = re.compile(pattern, re.I | re.M)
    if (exp.search(doc.content['title'][0]) or
        exp.search(" ".join(doc.content['author'])) or
        exp.search(doc.content['summary'][0]) or
        exp.search(doc.content['conf'][0]) or
        exp.search(doc.content['comment'][0])):
      dirpath = os.path.abspath(doctree.path)
      dirpath = dirpath.replace(os.path.abspath(config['input_path']), "").lstrip('/')
      node_hash[doc.content['title'][0].encode("utf_8")] = (doc, dirpath)
  return node_hash

def generate_doclist_html(pattern):
  html_output = ""
  doctree = td_doctree.build(config['input_path'])
  node_hash = node_hash_matching_pattern(doctree, pattern)
  for (node,dirpath) in node_hash.values():
    html_output += td_html.generate_html_code(node, dirpath)
  return html_output

def generate_root_html(pattern, doclist_html):
  tpl = os.path.join(config['templates_path'], 'html/search.html.tpl')
  subs = {
    '%%DOCS_LIST%%'     : doclist_html,
    '%%SITE_ROOT%%'     : config['site_root'],
    '%%VERSION%%'       : ac_config.version,
    '%%PATTERN%%'       : pattern
  }
  return td_tools.replace_in_template(tpl, subs)

def highlight_pattern(pattern, raw_html):
  pattern_regexp = re.compile("("+pattern+")", re.I | re.M)
  tag_regexp = re.compile(r'(<.*?>)', re.I | re.M |re.DOTALL)
  strings = tag_regexp.split(raw_html)
  output = ""
  for s in strings:
    if not tag_regexp.match(s):
      output += pattern_regexp.sub(r'<span style="background-color: yellow;color:red;">\1</span>', s)
    else:
      output += s
  return output

read_config(cgi_config.file)
pattern = process()
doclist_html = generate_doclist_html(pattern)
raw_html = generate_root_html(pattern, doclist_html)
highlighted_html = highlight_pattern(pattern, raw_html)
print highlighted_html.encode("utf_8")
