# This file is part of Tidydoc.
# Copyright (C) 2005, 2008, 2009 Nicolas Burrus
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os, sys

import ac_config
import td_debug

config = {}

def read_config(config_file = None):
  global config
  if (config_file):
    candidates = [config_file]
  else:
    candidates = [os.path.join(os.getenv("HOME"), ".tidydoc.conf"),
                  os.path.join(ac_config.prefix, "etc/tidydoc.conf"),
                  "/etc/tidydoc/tidydoc.conf",
                  "/etc/tidydoc.conf"]
  found = False
  for f in candidates:
    if not os.path.exists(f):
      continue
    else:
      found = True
      #td_debug.debug("Reading from " + f)
      try:
        execfile(f, config, config)
        break
      except:
        sys.stderr.write(f + " is not a valid configuration file.")
        sys.stderr.write(sys.exc_info())
  
  if not found:
    raise Exception("No configuration file found.")
