#!/usr/bin/env python
#
# This file is part of Tidydoc.
# Copyright (C) 2005, 2008, 2009 Nicolas Burrus
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os, re, sys
import shutil

from td_tools import *
import td_config
import td_doctree
import td_debug
import td_html
from td_config import config
import ac_config
import tempfile

def copy_and_postprocess(source_html, dest_html, category):
  f = open(source_html, 'r')
  lines = f.readlines()
  f.close()
  
  f = open(dest_html, 'w')
  for l in lines:
    f.write(l.replace(config['site_root'] + "/" + category + "/", ""))
  f.close()

def generate_category(doctree, category, outputfile):
  td_html.generate_html(doctree)
  node = td_doctree.walk_to_category(doctree, category)
  if not node:
    raise Exception("Category not found.")
  dirname = rel_path(node.path).replace('/','_')
  files = []
  for doc in node.docs:
    files.append(doc.content['file'][0])
  tempdir = tempfile.mkdtemp(suffix="tidydoc_archive")
  if not tempdir:
    raise Exception("Could not create temporary directory.")
  cmds = 'mkdir -p "%s/%s" \n' % (tempdir, dirname)
  (status, output) = exec_commands(cmds)
  if status != 0:
    raise Exception("Could not prepare archive, output is: " + output)
  
  copy_and_postprocess(node.path + '/' + "doclist.html", 
                       tempdir + '/' + dirname + '/' + "index.html",
                       rel_path(node.path))
  
  cmds = 'cd "%s/%s"\n' % (tempdir,dirname)
  for f in files:
    cmds += 'cp "%s" .\n' % (node.path + '/' + f)
  cmds += "cd ..\n"
  cmds += 'zip -r archive.zip "%s"\n' % dirname
  (status, output) = exec_commands(cmds)
  if status != 0:
    raise Exception("Could not prepare archive, output is: " + output)
  shutil.move(tempdir + "/archive.zip", outputfile)
  shutil.rmtree(tempdir)
