#!/usr/bin/python
# This file is part of Tidydoc.
# Copyright (C) 2005, 2008, 2009 Nicolas Burrus
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import cgi_config

import sys;
import os, os.path, glob
import re
import cgi;
import cgitb; cgitb.enable()

import ac_config
from td_config import config,read_config
import td_tools
import shutil
import td_reorganize_doc
import td_tools

import td_debug
td_debug.in_cgi = True

form = cgi.FieldStorage()

print "Content-type: text/html; charset=UTF-8"
print

print "<html>"
print "<head>"
print '<link rel="stylesheet" href="../style.css">'
print "</head>"
print "<body>"
print "<table border=\"1\" width=\"100%\" cellpadding=\"3\" cellspacing=\"1\">"
print '<tr><td bgcolor=\"#CACAF7\" align=\"center\"><span class="pagetitle">-=[Delete a category]=-</a></span></td></tr></table><br>'

def error(msg):
  print "<H1>Error</H1>"
  print msg

def getPath():
  if not (form.has_key("category")):
    return None
  
  category = form["category"].value
  if (category == ""):
    return None
  
  return os.path.join(config['upload_dest_path'], category)

def removeDocsFromDir(path, category):
  for dsc in glob.glob(os.path.join(path, '*.dsc')):
    try:
      f = open(dsc, "r")
      lines = f.readlines()
      f.close()
      
      categorySec = False
      for i,line in enumerate(lines):
        if not categorySec:
          m = re.match('^Categories:\s*(.*)', line)
          if m != None:
            categorySec = True
            lines[i] = "Categories:\n"
        else:
          m = re.match('^\s*' + category + '\s*$', line)
          if m != None:
            lines.remove(line)
          
      f = open(dsc, "w")
      f.writelines(lines)
      f.close()
      td_reorganize_doc.reorganize(dsc)
    except Exception, e:
      error("Could not read document path.")
      raise e

def containsDir(dirPath):
  contents = os.listdir(dirPath)
  dirList=[item for item in contents if os.path.isdir(os.path.join(dirPath,item))]
  return not dirList == list()

def doDelete(destdir):
  category = form["category"].value
  if os.path.exists(destdir):
    if len(glob.glob(os.path.join(destdir, '*.dsc'))) == 0 and not containsDir(destdir):
      #removeDocsFromDir(destdir, category)
      shutil.rmtree(destdir)
      print "Category \"" + category + "\" successfully deleted."
      print """
      <br><br>
      <form action="regenerate.cgi" method="post">
      <input type="submit" name="submit" value="Regenerate HTML"/>
      <br><br>
      </form>
      """
    else:
      print "Category \"" + category + "\" is not empty."
  else:
    print "Category \"" + category + "\" does not exist."

def proposeCategories():
  f = open(config['categories_path'], "r")
  lines = f.readlines()
  f.close()

  print '<form method="post" action="delete_category.cgi">'
  
  categories = []
  for l in lines:
    m = re.match('%(\s)*(\S)+(.*)', l)
    if m != None:
      categories.append((l.lstrip("% ")).rstrip())
  print '<select name="category" size=1>'
  print '<option selected value="">Choose a category</option>'
  for c in categories:
    print '<option value="%s">%s</option>' % (c,c)
  print '</select>'
  print '<input type="submit" name="submit" value="Submit"/>'
  print '</form>'

read_config(cgi_config.file)
destdir = getPath()
if destdir:
  doDelete(destdir)
else:
  proposeCategories()

print "</body></html>"
