#!/usr/bin/python
# This file is part of Tidydoc.
# Copyright (C) 2005, 2008, 2009 Nicolas Burrus
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import cgi_config

import sys, os, os.path
import re
from urlparse import urlparse

import cgi;
import cgitb; cgitb.enable()

import ac_config
from td_config import config,read_config
import td_tools
import td_upload

form = cgi.FieldStorage()

print "Content-type: text/html; charset=UTF-8"
print

print "<html>"
print "<head>"
print '<link rel="stylesheet" href="../style.css">'
print "</head>"
print "<body>"
print "<table border=\"1\" width=\"100%\" cellpadding=\"3\" cellspacing=\"1\">"
print '<tr><td bgcolor=\"#CACAF7\" align=\"center\"><span class="pagetitle">-=[Edit document]=-</a></span></td></tr></table><br>'

def error(msg):
  print "<H1>Error</H1>"
  print msg

def process():
  if not (form.has_key("docpath")):
    error("Bad post data.")
    return

  docpath = form["docpath"].value
  docpath.lstrip('/')
  docpath = os.path.normpath(docpath)

  fulldocpath = config['input_path'] + '/' + docpath
  fulldscpath = fulldocpath + ".dsc"

  if not os.path.exists(fulldscpath):
    error("Document does not exist: " + fulldscpath)
    return

  f = open(fulldscpath, "r")
  data = f.read()
  f.close()

  return (docpath, data)

def modification_form(docpath, dscdata):
  nbrows = dscdata.count('\n')
  print """
<form action="modify_apply.cgi" method="post" accept-charset="UTF-8">
<input type="hidden" name="docpath" value="%(docpath)s"/>
<br>
<TEXTAREA style="font-size: 8pt;" name="dsc" rows="40" cols="80">
%(dscdata)s
</TEXTAREA>
<br><br>
<input type="submit" name="submit" value="Submit"/>
</form>
""" % (locals())

read_config(cgi_config.file)
(docpath, dscdata) = process()

try:
  print docpath
except:
  error("Could not read document path.")

modification_form(docpath, dscdata)

print "</body></html>"
