#!/usr/bin/python
# This file is part of Tidydoc.
# Copyright (C) 2005, 2008, 2009 Nicolas Burrus
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import cgi_config

import sys;
import os, os.path
import re

import cgi;
import cgitb; cgitb.enable()

import ac_config
from td_config import config,read_config
import td_tools
import td_reorganize_doc

import td_debug
td_debug.in_cgi = True

form = cgi.FieldStorage()

print "Content-type: text/html; charset=UTF-8"
print

print "<html>"
print "<head>"
print '<link rel="stylesheet" href="../style.css">'
print "</head>"
print "<body>"
print "<table border=\"1\" width=\"100%\" cellpadding=\"3\" cellspacing=\"1\">"
print '<tr><td bgcolor=\"#CACAF7\" align=\"center\"><span class="pagetitle">-=[Move documents]=-</a></span></td></tr></table><br>'

read_config(cgi_config.file)
if not (form.has_key("categories")) or not (form.has_key("documents")):
  print "You must provide document(s) and category(ies)"
else:
  docs = form.getvalue("documents")
  if not isinstance(docs, list):
    docs = [docs]
  cats = form.getvalue("categories")
  if not isinstance(cats, list):
    cats = [cats]
  
  for d in docs:
    try:
      dsc = config['input_path'] + '/' + d + ".dsc"
      f = open(dsc, "r")
      lines = f.readlines()
      llines = list(lines)
      f.close()
      categorySec = False
      for l in lines:
        if not categorySec:
          m = re.match('^Categories:\s*(.*)', l)
          if m != None:
            categorySec = True
        else:
          llines.remove(l)
      for c in cats:
        llines.append(c+'\n')
      f = open(dsc, "w")
      f.writelines(llines)
      f.close()
      td_reorganize_doc.reorganize(dsc)
    except Exception, e:
      print "Could not move document (maybe it does not have a dsc file)?"
      raise e
  print "Document(s) successfully moved."
  print """
  <br><br>
  <form action="regenerate.cgi" method="post">
  <input type="submit" name="submit" value="Regenerate HTML"/>
  <br><br>
  </form>
  """
print "</body></html>"
