#!/usr/bin/env python
# This file is part of Tidydoc.
# Copyright (C) 2005, 2008, 2009 Nicolas Burrus
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import ac_config

from getopt import getopt
from urlparse import urlparse
import os, shutil, sys

from td_config import config, read_config
import td_dsc
from td_tools import *
import td_upload
import td_debug

def print_help():
  sys.stderr.write(
"""Usage: td-add-doc [options] document_file [description_file]

  Options

  -c, --config configfile  Config file to use.
  -v, --version            Print version number.

Nicolas Burrus <nicolas.burrus@ensta.fr>
""")

def parse_command_line(argv):
  try: (options, args) =  getopt(argv[1:], "vc:", ["version", "config"])
  except:
    print_help()
    sys.exit(1)

  cmd_options = {}
  cmd_options['config_file'] = None

  for option in options:
    if option[0] == "-v" or option[0] == "--version":
      print "Tidydoc " + ac_config.version
      print "Nicolas Burrus <nicolas.burrus@ensta.fr>"
      sys.exit(0)
    if option[0] == "-c" or option[0] == "--config":
      cmd_options['config_file'] = option[1]

  if len(args) < 1 or len(args) > 2:
    print_help()
    sys.exit(1)

  cmd_options['doc_file'] = args[0]
  if len(args) > 1:
    cmd_options['dsc_file'] = args[1]
  else:
    cmd_options['dsc_file'] = None

  return cmd_options

def __main__():
  cmd_options = parse_command_line(sys.argv)
  read_config(cmd_options['config_file'])
  orig_doc_path = cmd_options['doc_file']
  orig_doc_url = ""
  orig_dsc_path = cmd_options['dsc_file']

  if re.match("^(ht|f)tps?://", orig_doc_path):
    docname = os.path.basename(urlparse(orig_doc_path)[2])
    orig_doc_url = orig_doc_path
    orig_doc_path = "/tmp/tidydoc_" + docname
    try:
      exec_commands('wget --no-check-certificate "%s" -O %s\n' % (orig_doc_url, orig_doc_path))
    except:
      sys.stderr.write("Could not download `%s'\n" % orig_doc_url)
      sys.exit(1)

  if not os.path.exists(orig_doc_path):
    sys.stderr.write("`%s': not found.\n" % orig_doc_path)
    sys.exit(1)

  if orig_dsc_path and not os.path.exists(orig_dsc_path):
    sys.stderr.write("`%s': not found.\n" % orig_dsc_path)
    sys.exit(1)
  
  tmp_dsc_path = "/tmp/tidydoc_%s.dsc" % os.path.basename(orig_doc_path)
  if orig_dsc_path:
    shutil.copy(orig_dsc_path, tmp_dsc_path)
  else:
    # Fill it with default values.
    if not os.path.exists(tmp_dsc_path):
      f = open(config['categories_path'], "r")
      categories = f.read()
      f.close()
      props = guess_desc_from_doc(orig_doc_path)
      props['categories'] = categories
      props['url'] = orig_doc_url
      f = open(tmp_dsc_path, "w")
      f.write(\
"""Title: %(title)s

%% One per line. End by the last name. eg: D. Knuth
Author: %(author)s

%% End it by the year. eg: Oct 2004
Date: %(date)s

%% Use short names. eg: siggraph
Conf: 

Pages: %(pages)s

Keywords: 

Link: %(url)s

%% Line breaks are taken into account.
Abstract: 

Visibility: public

Language: english

Bibtex:

Comment:

%% Uncomment as many as you want, links will be created.
%% You can create subcategories using '/', for example:
%% math
%% math/statistics
%% math/statistics/sampling
Categories:
%(categories)s""" % props)
      f.close()

  # Create command
  cmds = config['add_doc_commands'] % locals()

  td_debug.debug("Executing %s" % cmds)
  status = exec_interactive_commands(cmds)
  if status != 0:
    print "Error in document addition commands."
    sys.exit(1)

  td_upload.upload(orig_doc_path, tmp_dsc_path)

if __name__ == "__main__":
  __main__()
