# This file is part of Tidydoc.
# Copyright (C) 2005, 2008, 2009 Nicolas Burrus
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import xml.dom.minidom

def get_text(nodelist):
    rc = ""
    for node in nodelist:
        if node.nodeType == node.TEXT_NODE:
            rc = rc + node.data
    return rc

fields = [ 'author',
           'comment',
           'conf',
           'date',
           'file',
           'language',
           'nbpages',
           'summary',
           'title',
           'type',
           'url',
           'bibtex',
           ]

def parse(fname):  
  dom = xml.dom.minidom.parse(fname)
  dom = dom.getElementsByTagName("document")[0]

  doc = {}  
  for field in fields:
    try:
      content_list = dom.getElementsByTagName(field)
    except:
      content_list = None
    if content_list:
      doc[field] = []
      for content in content_list:
        doc[field].append(get_text(content.childNodes))
    else:
      doc[field] = [""]
  return doc
