#!/usr/bin/env python
#
# This file is part of Tidydoc.
# Copyright (C) 2005, 2008, 2009 Nicolas Burrus
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from getopt import getopt
from glob import glob
import os, re, sys

import ac_config
import td_config
from td_config import config
import td_doctree
import td_dsc_to_xml
import td_html
import td_bibtex
from td_tools import *

def print_help():
  sys.stderr.write(
"""Usage: td-search text

  Options

  -c, --config configfile  Config file to use.
  -v, --version            Print version number.

Nicolas Burrus <nicolas.burrus@ensta.fr>
""")

def parse_command_line(argv):
  try: (options, args) =  getopt(argv[1:], "vc:",
                                 ["version", "config"])
  except:
    print_help()
    sys.exit(1)

  if len(args) != 1:
    print_help()
    sys.exit(1)

  cmd_options = { 'config_file' : None }
  cmd_options['pattern'] = args[0]

  for option in options:
    if option[0] == "-v" or option[0] == "--version":
      print "Tidydoc " + ac_config.version
      print "Nicolas Burrus <nicolas.burrus@ensta.fr>"
      sys.exit(0)
    if option[0] == "-c" or option[0] == "--config":
      cmd_options['config_file'] = option[1]
  return cmd_options

def generate_doctree():
  doctree = td_doctree.build(config['input_path'])
  return doctree

def dump_doc_matching_pattern(doctree, text, indent=0):
  for subdir in doctree.subdirs:
    print " " * indent, "`--", os.path.basename(subdir.path)
    dump_doc_matching_pattern(subdir, text, indent+6)
  for doc in doctree.docs:
    exp = re.compile(text, re.I | re.M)
    if (exp.search(doc.content['title'][0]) or
        exp.search(" ".join(doc.content['author'])) or
        exp.search(doc.content['summary'][0]) or
        exp.search(doc.content['comment'][0])):
      print " " * indent, doc.content['title'][0].encode("utf_8")

def __main__():
  cmd_options = parse_command_line(sys.argv)
  try:
    td_config.read_config(cmd_options['config_file'])
  except:
    sys.stderr.write(str(sys.exc_info()[0]) + "\n")
    sys.exit(1)

  doctree = generate_doctree()
  dump_doc_matching_pattern(doctree, cmd_options['pattern'])

if __name__ == "__main__":
  __main__()
  
