#!/usr/bin/python
# This file is part of Tidydoc.
# Copyright (C) 2005, 2008, 2009 Nicolas Burrus
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import cgi_config

import sys;
import os, os.path
import re
from urlparse import urlparse

import cgi;
import cgitb; cgitb.enable()

import ac_config
from td_config import config,read_config
import td_tools
import td_upload

print "Content-type: text/html; charset=UTF-8"
print

form = cgi.FieldStorage()

print "<html><body>"
print "<table border=\"1\" width=\"100%\" cellpadding=\"3\" cellspacing=\"1\">"
print "<tr><td bgcolor=\"#CACAF7\" align=\"center\"><b>-=[Upload a document]=-</a></b></td></tr></table><br>"

def error(msg):
  print "<H1>Error</H1>"
  print msg

def process():
  if not (form.has_key("docpath") and form.has_key("dsc")):
    error("Bad post data.")
    return

  dsc = form["dsc"].value
  dsc = "\n".join(dsc.splitlines())
  docpath = form["docpath"].value

  if not os.path.exists(docpath):
    error("Document does not exist: " + docpath)
    return

  dscpath = docpath + ".dsc"
  f = open(dscpath, "w")
  f.write(dsc)
  f.close()

  return (dscpath, docpath)

def confirmation_form(dscpath, docpath):
  print """
<br><br>
<form action="upload.cgi" method="post">
<input type="hidden" name="docpath" value="%s"/>
<input type="hidden" name="dscpath" value="%s"/>
<input type="submit" name="submit" value="Validate"/>
</form>
<br><br>
""" % (docpath, dscpath)

read_config(cgi_config.file)
(dscpath, docpath) = process()

(cmd, log) = td_upload.get_upload_cmd(docpath, dscpath)
print "<pre>" + cmd + "</pre>"
print "<ptr>" + log + "</pre>"
confirmation_form(dscpath, docpath)

print "</body></html>"
