#!/usr/bin/python
# This file is part of Tidydoc.
# Copyright (C) 2005, 2008, 2009 Nicolas Burrus
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import cgi;
import cgitb; cgitb.enable()

import cgi_config

import sys, os, os.path
import re
from urlparse import urlparse

import ac_config
from td_config import config,read_config
import td_tools
import td_upload
import td_reorganize_doc

import td_debug
td_debug.in_cgi = True

form = cgi.FieldStorage()

print "Content-type: text/html; charset=UTF-8"
print
print "<html><body>"

def error(msg):
  print "<H1>Error</H1>"
  print msg

def process():
  if not (form.has_key("docpath") and form.has_key("dsc")):
    error("Bad post data.")
    return

  docpath = form["docpath"].value
  docpath.lstrip('/')
  docpath = os.path.normpath(docpath)
  fulldocpath = config['input_path'] + '/' + docpath
  fulldscpath = fulldocpath + ".dsc"

  if not os.path.exists(fulldscpath):
    error("Document does not exist: " + fulldscpath)
    return

  dsc = form["dsc"].value.decode("utf_8")
  dsc = "\n".join(dsc.splitlines())

  f = open(fulldscpath, "w")
  if not f:
    error("Could not write dsc file: " + fulldscpath)
  f.write(dsc.encode("utf_8"))
  f.close()

  return fulldscpath

def regeneration_form():
  print """
<br><br>
<form action="regenerate.cgi" method="post">
<input type="submit" name="submit" value="Regenerate HTML"/>
<br><br>
</form>
"""

read_config(cgi_config.file)
fulldscpath = process()

try:
  td_reorganize_doc.reorganize(fulldscpath)
  regeneration_form()
except Exception, e:
  error("Could not read document path.")
  raise e

print "</body></html>"
