#!/usr/bin/python
# This file is part of Tidydoc.
# Copyright (C) 2005, 2008, 2009 Nicolas Burrus
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import cgi_config

import sys, os, os.path
import re
from urlparse import urlparse

import cgi;
import cgitb; cgitb.enable()

import ac_config
from td_config import config,read_config
import td_tools
import td_upload

print "Content-type: text/html; charset=UTF-8"
print

form = cgi.FieldStorage()

print "<html>"
print "<head>"
print '<link rel="stylesheet" href="../style.css">'
print "</head>"
print "<body>"
print "<table border=\"1\" width=\"100%\" cellpadding=\"3\" cellspacing=\"1\">"
print '<tr><td bgcolor=\"#CACAF7\" align=\"center\"><span class="pagetitle">-=[Upload a document]=-</a></span></td></tr></table><br>'

def error(msg):
  print "<H1>Error</H1>"
  print msg

def process():
  if not (form.has_key("docpath") and form.has_key("dscpath")):
    error("Bad post data.")
    return

  dscpath = form["dscpath"].value
  docpath = form["docpath"].value

  return (dscpath, docpath)

def remove_html_view_files(docpath):
  docbasename = os.path.basename(docpath)
  tempdir = config['output_path'] + "/temp"
  cmd = """
rm -f "%(tempdir)s/%(docbasename)s"*.html
""" % locals()
  print cmd
  td_tools.exec_commands(cmd)

def regeneration_form():
  print """
<br><br>
<form action="regenerate.cgi" method="post">
<input type="submit" name="submit" value="Regenerate HTML"/>
<br><br>
</form>
"""

read_config(cgi_config.file)
(dscpath, docpath) = process()

try:
  td_upload.upload(docpath, dscpath, 0)
  os.remove(docpath)
  os.remove(dscpath)
  remove_html_view_files(docpath)
  regeneration_form()
except:
  error("Could not upload file. Check permissions for the web user?")

print "</body></html>"
