#!/usr/bin/python -O
#    $Id: irclog.py,v 1.11 2002/08/20 16:35:24 tilk Exp $
#    tilkIRClog
#    Copyright (C) 2001  Marek "Tilk" Materzok
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Import function modules

from irclog_confclass import irclog_config
import irclog_class

# import python classes

import time,re,os,getopt,sys

# check commandline options

try:
    optlist, args = getopt.getopt(sys.argv[1:],"hnvq")
    if len(args) > 0:
	raise GetoptError
except:
    print "Invalid options! Use -h to see help."
    raise SystemExit

nodaemon = None

for opt in optlist:
    if opt[0] == "-h":
	print "Options:\n-h - this help\n-n - no daemonize\n-v - version\n-q - quiet"
	raise SystemExit
    if opt[0] == "-v":
	print "tilkIRClog 1.0.2"
	raise SystemExit
    if opt[0] == "-n":
	nodaemon = 1
    if opt[0] == "-q":
	xstdout = os.open ("%s/debug_file" % irclog_config.directory, os.O_WRONLY | os.O_CREAT | os.O_APPEND)
	os.dup2 (xstdout, 1)
	os.dup2 (xstdout, 2)

# Reading PIDfile (if exists)

pidfile = "%s/irclog.pid" % irclog_config.directory

try:
    f = open (pidfile, "r");
    pid = int(f.readline ())
    f.close ()
except:
    pid = 0

# If we have PIDfile, check for validity
if pid != 0 and pid != os.getpid():
    p = os.popen ("ps wux | grep %d | grep irclog.py | grep -v -c grep" % pid,"r")
    active = int(p.readline())
    p.close()
    if active >= 1:
	print "Already running tilkIRClog at PID %d" % pid
	raise SystemExit
    pid = 0
    os.unlink(pidfile)

# Daemonize
if not nodaemon:
    pid = os.fork()
    if pid != 0:
	f = open (pidfile, "w")
	f.write ("%s\n" % str(pid))
	f.close ()
	raise SystemExit
else:
    pid = os.getpid()
    f = open (pidfile, "w")
    f.write ("%s\n" % str(pid))
    f.close ()

# /dev/null-ize stdin, stdout and stderr
if not nodaemon:
    stdin = os.open ("/dev/null", os.O_RDONLY)
#    stdout = os.open ("/dev/null", os.O_WRONLY)
    stdout = os.open ("%s/debug_file" % irclog_config.directory, os.O_WRONLY | os.O_CREAT | os.O_APPEND)
    os.dup2 (stdin, 0)
    os.dup2 (stdout, 1)
    os.dup2 (stdout, 2)

try:
    IrcLogRun = irclog_class.IrcLogClass()
    IrcLogRun()
except "ThreadExit":
    pass
except SystemExit:
    os.unlink(pidfile)

