#    $Id: irclog_class.py,v 1.32 2002/07/03 12:03:40 tilk Exp $
#    tilkIRClog
#    Copyright (C) 2001  Marek "Tilk" Materzok
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Import function modules

from irclog_confclass import irclog_config
import irclog_timer
import irclog_log
import irclog_support
import irclink
import prefixes

# import python classes

import time,re,os,getopt,sys,string,md5,sha,socket

class IrcLogClass:
    def __init__(self):
	self.timer = irclog_timer.Timer(irclog_config.sendhour)
	self.logfile = irclog_log.LogFile()
	self.lastsendmsg = {"ctcp":0, "mode":0}
	self.hostmask = irclog_support.HostMask()
	self.buc_pattern = re.compile ("(\x03"+r"(\d{1,2}(,\d{1,2})?)?)"+"|\x02|\x03|\x1f")

    # SELEKCJA SERWERA
    def __call__(self):    
	while 1 == 1:
	    for serv in irclog_config.servers:
		try:
		    self.socket = irclink.irclink(serv[0],serv[1])
		    self.socket.connect()
		except irclink.Error:
		    continue

		self.server = serv[0]
		self.nick = irclog_config.nicks[0]
		if len(serv) > 2 and serv[2]:
		    self.socket.PASS(serv[2])
		self.socket.NICK(self.nick)
		self.socket.USER(irclog_config.ident,irclog_config.realname)

		try:
		    self.data_loop(self.nick)
		except "rehash":
		    del self.logfile
		    self.logfile = irclog_log.LogFile()
		    break
		except "leave":
		    continue

    # Wykonuje ladnie wygladajacego hosta z prefiksu
    def gen_host_from_prefix (self,prefix,irclook=None):
	if not irclook:
	    return "%s (%s@%s)" % (prefix[0],prefix[2],prefix[1])
	else:
	    return "%s!%s@%s" % (prefix[0],prefix[2],prefix[1])

    # Funkcje zajmujace sie przekodowaniem %B%U%Cow (kolorki itp.)
    def buccode (self, x):
	if x.group(0)[0] == "\x02":
	    thecode = "B"
	if x.group(0)[0] == "\x1f":
	    thecode = "U"
	if x.group(0)[0] == "\x03":
	    thecode = "C"
	return "(%s%s)" % (thecode, x.group(0)[1:])

    def unbuc (self, mystr):
	if not irclog_config.decodecolors:
	    return mystr
	return self.buc_pattern.sub (self.buccode, mystr)

    # Dba o to, zeby odpowiedzi szedly nie czesciej niz raz na sekunde
    def limited_send (self, msg, typ = "ctcp"):
	if int(time.time()) > self.lastsendmsg[typ]:
	    self.socket.writeline(msg)
	    self.lastsendmsg[typ] = int (time.time())

    # Probuje odzyskac glownego nicka, czy to z servicami, czy bez nich
    def check_and_reclaim_nick (self):
	if self.nick == irclog_config.nicks[0]:
	    return
	if irclog_config.use_services:
	    self.socket.NICKSERV("RECOVER %s %s" % (irclog_config.nicks[0],
	    	    irclog_config.services_password))
	    self.socket.NICKSERV("RELEASE %s %s" % (irclog_config.nicks[0],
		    irclog_config.services_password))
	    self.socket.NICK(irclog_config.nicks[0])
	    self.check_and_identify()
	else:
	    self.socket.NICK(irclog_config.nicks[0])

    # Identyfikuje sie w Services, jesli ma glownego nicka
    def check_and_identify (self):
	if irclog_config.use_services and self.ournick(irclog_config.nicks[0]):
	    self.socket.NICKSERV("IDENTIFY %s" % irclog_config.services_password)

    # Zamyka polaczenie z wybranym komunikatem
    def close_connection (self, qmsg = ""):
	mtext = "Closing connection: %s" % qmsg;
	if irclog_config.mircformat:
	    self.logfile.local_msg ("private", prefixes.Elog, mtext)
	else:
	    self.logfile.global_msg (prefixes.Elog, mtext);
	try:
	    qm = irclog_config.quitmsg
	    if qmsg != "":
		qm = "%s (%s)" % (qm, qmsg)
	    self.socket.QUIT(qm)
	    while self.socket.write_sock() == 1:
		time.sleep(1)
	except irclink.Error:
	    pass
	try:
	    del self.socket	
	except:
	    pass

    # Porownuje nicka z parametru z wlasnym nickiem
    def ournick(self,nicktwo):
	if self.nick.lower() == nicktwo.lower():
	    return 1
	return None

    # Services Self AOP
    def services_self_aop(self):
	for chan in self.act_chanlist.list_chans():
	    if irclog_config.use_services and irclog_config.serv_privs.has_key(chan):
		privs = irclog_config.serv_privs[chan]
		if (3 <= privs < 5) and (self.act_nicklist.return_mode(chan,self.nick) == ""):
		    self.socket.CHANSERV("VOICE %s %s" % (chan, self.nick))
		if (privs >= 5) and (self.act_nicklist.return_mode(chan,self.nick) != "@"):
		    self.socket.CHANSERV("OP %s %s" % (chan, self.nick))

    # Funkcje wywolywane raz na minute
    def maintenance_functions(self):
	if time.time() <= self.last_chancheck + 60:
	    return
	
	self.last_chancheck = time.time()

	# sprawdzamy, czy nalezy wyslac logi
	if self.timer.check_trigger() == 1:
	    self.logfile.mail_logs()
	    
	# Reagujemy na zmiane konfiguracji
	if irclog_config.newconfig():
	    if irclog_config.mircformat:
		self.logfile.local_msg("private", prefixes.Elog,
		    "Config file changed; reconnecting")
	    else:
		self.logfile.global_msg(prefixes.Elog, 
		    "Config file changed; reconnecting")
	    self.close_connection("Rehash")
	    raise "rehash"

	# Probujemy odzyskac nick i zidentyfikowac sie
	self.check_and_reclaim_nick()
	self.check_and_identify()
	self.services_self_aop()

	# Zbieramy trupy
	try:
	    os.wait()
	except:
	    pass

	# Jesli jestesmy polaczeni pingujemy serwer
	if self.__dict__.has_key("server"):
	    self.socket.PING(self.server)

	# Jesli mamy ping timeouta - rekonektujemy
	if time.time() - self.last_pong > 180:
	    self.close_connection("Server ping timeout")
	    raise "leave"
	
	# Joinujemy do kanalow, z ktorych nas wygnano		    
	for chan in irclog_config.channels:
	    if not self.act_chanlist.has_chan(chan):
		self.socket.JOIN(chan)

    # Glowna petla loggera
    def data_loop(self, nick):
	functions = {
	"433": self.NICKINUSE,
	"001": self.WELCOME,
	"PING": self.PING,
	"PONG": self.PONG,
	"TOPIC": self.TOPIC,
	"332": self.TOPIC,
	"333": self.TOPICWHOTIME,
	"PRIVMSG": self.PRIVMSG,
	"NOTICE": self.NOTICE,
	"JOIN": self.JOIN,
	"PART": self.PART,
	"QUIT": self.QUIT,
	"KICK": self.KICK,
	"353": self.NAMES,
	"324": self.CHANNELMODEIS,
	"366": self.ENDOFNAMES,
	"367": self.BANLIST,
	"NICK": self.NICK,
	"MODE": self.MODE,
	"473": self.INVITEONLY,
	"474": self.BANNED,
	"INVITE": self.INVITE,
	"ERROR": self.ERROR
	};
    
	self.last_chancheck = time.time() - 30
	self.last_pong = time.time() + 120
	self.act_chanlist = irclog_support.ChanList() 	# lista kanalow, na ktorych jestesmy w tej chwili
	self.act_banlist = irclog_support.ChanList()	# lista kanalow, na ktorych jestesmy zbanowani
	self.act_nicklist = irclog_support.NickList()	# lista nickow na kanalach
	self.act_largestnick = irclog_support.LargestNick()	# najwiekszy rozmiar nicka na kanalach; indent
	self.quiet_names = {}

	while 1 == 1:
	    # pulling events
	    event = None
	    while event == None:
	        try:
		    event = self.socket.pollevent()
	        except irclink.Error:
		    self.close_connection("Socket broken")
		    raise "leave"
		self.maintenance_functions()

	    # odpowiadamy na komunikaty od serwera:
	    try:
		if functions.has_key(event["command"]):
		    functions[event["command"]](event)
# do analizy struktury event
#		else:
#		    print event
	    except irclink.Error:
		raise "leave"
	
    # 433 - nick w uzyciu
    def NICKINUSE(self,event):
	try:
	    ind = irclog_config.nicks.index(self.nick) + 1
	except:
	    ind = 0
	if ind >= len (irclog_config.nicks):
	    ind = 0
	self.nick = irclog_config.nicks[ind]
	self.socket.NICK(self.nick)

    # 001 - polaczony z serwerem
    def WELCOME(self,event):
	self.server = event["prefix"]
	mtext = "Connected to %s as %s" % (event["prefix"][0], self.nick)
	if irclog_config.mircformat:
	    self.logfile.local_msg ("private", prefixes.Slog, mtext)
	else:
	    self.logfile.global_msg (prefixes.Slog, mtext)
	self.check_and_identify()
	time.sleep(1)
	self.socket.AWAY(irclog_config.awaymsg)
	time.sleep(1)
	for chan in irclog_config.channels:
	    self.socket.JOIN(chan)
	self.check_and_reclaim_nick()

    # PING - wiadomo co :>
    def PING(self,event):
	self.socket.PONG(event["params"])

    # PONG
    def PONG(self,event):
	self.last_pong = time.time ()

    # TOPIC
    def TOPIC(self,event):
	channame = event["params"][0].lower()
	if len(event["prefix"]) > 1:
	    msg = "%s changes topic to '%s'" % (event["prefix"][0],
		self.unbuc(event["params"][1]));
	else:
	    msg = "Topic is '%s'" % self.unbuc(event["params"][1])
	self.logfile.local_msg (channame, prefixes.Info, msg)

    # TOPICWHOTIME
    def TOPICWHOTIME(self,event):
	channame = event["params"][0].lower()
	self.logfile.local_msg (channame, prefixes.Info, "Set by %s on %s" % 
	    (event["params"][1], time.asctime(time.localtime(int(
	     event["params"][2])))))

    # administracyjne CTCP'ki
    def ADMINCTCP(self,msg,event):
	params = msg.split()
	remotehost = self.gen_host_from_prefix(event["prefix"],1)

	# parameter count check
	if len(params) < 3:
	    self.logfile.local_msg ("private", prefixes.Info, 
		"Failed command (%s) by %s (not enough params)" % (msg,remotehost))
	    return

	# hostmask check
	for hostmask in irclog_config.adminhosts:
	    if self.hostmask.compare(remotehost,hostmask):
		break
	else:
	    self.logfile.local_msg ("private", prefixes.Info, 
		"Failed command (%s) by %s (bad hostmask)" % (msg,remotehost))
	    return

	# password check
	if irclog_config.pass_hash.lower() == "md5":
	    if md5.new(params[1]).hexdigest().lower() != irclog_config.password.lower():
		self.logfile.local_msg ("private", prefixes.Info, 
		    "Failed command (%s) by %s (bad password (md5))" % (msg,remotehost))
		return    
	elif irclog_config.pass_hash.lower() == "sha1":
	    if sha.new(params[1]).hexdigest().lower() != irclog_config.password.lower():
		self.logfile.local_msg ("private", prefixes.Info, 
		    "Failed command (%s) by %s (bad password (sha1))" % (msg,remotehost))
		return    
	else:
	    if params[1] != irclog_config.password:
		self.logfile.local_msg ("private", prefixes.Info, 
		    "Failed command (%s) by %s (bad password)" % (msg,remotehost))
		return    
		    
	if params[2].lower() == "shutdown":
	    mtext = "Shutdown by %s" % remotehost;
	    if irclog_config.mircformat:
		self.logfile.local_msg ("private", prefixes.Elog, mtext)
	    else:
		self.logfile.global_msg (prefixes.Elog, mtext)
	    self.close_connection("Shutdown")
	    raise SystemExit
	if params[2].lower() == "restart":
	    mtext = "Restart by %s" % remotehost;
	    if irclog_config.mircformat:
		self.logfile.local_msg ("private", prefixes.Elog, mtext)
	    else:
		self.logfile.global_msg (prefixes.Elog, mtext)
	    self.close_connection("Restart")
	    os.execv ("%s/irclog.py" % irclog_config.directory, ["./irclog.py","-n"])
	    raise SystemExit
	if params[2].lower() == "rehash":
	    irclog_config.newconfig()
	    mtext = "Rehash by %s" % remotehost;
	    if irclog_config.mircformat:
		self.logfile.local_msg ("private", prefixes.Elog, mtext)
	    else:
		self.logfile.global_msg (prefixes.Elog, mtext)
	    self.close_connection("Rehash")
	    raise "rehash"
	if params[2].lower() == "msg" and len(params) >= 5:
	    msg = string.join(params[4:])
	    self.socket.PRIVMSG(params[3],msg)
	    self.LOG_MSG(self.nick,params[3],msg)
	else:
	    self.logfile.local_msg ("private", prefixes.Info, 
		"Failed command (%s) by %s (invalid command)" % (msg, remotehost))

    def LOG_MSG(self,fromnick,recvr,msg):
	    recvr = recvr.lower()
	    if self.ournick(recvr):
		recvr = "private"
		
	    if fromnick[0] not in "+@" and recvr != "private":
		fromnick = self.act_nicklist.return_mode(recvr,fromnick) + fromnick
	    the_prefix = prefixes.Pmsg % fromnick
	    if irclog_config.indent_nick:
	        expan = ' ' * (self.act_largestnick[recvr] - len(fromnick) + 1)
	        if irclog_config.indent_nick == "left":
		    the_prefix = the_prefix + expan
		elif irclog_config.indent_nick == "right":
		    the_prefix = expan + the_prefix
	    self.logfile.local_msg (recvr, the_prefix, self.unbuc(msg))
	

    # PRIVMSG
    def PRIVMSG(self,event):
	recvr = event["params"][0].lower()
	msg = event["params"][1]
	fromnick = event["prefix"][0]

	if fromnick in irclog_config.ignorelist:
	    return

	# log private messages to "private" log
	if self.ournick(recvr):
	    recvr = "private"
	else:
	    fromnick = self.act_nicklist.return_mode(recvr,fromnick) + fromnick

	# Message is not CTCP?
	if msg[0] != "\x01" and msg[-1] != "\x01":
	    self.LOG_MSG(fromnick, recvr, msg) 
	else:
	    # it's CTCP
	    msg = msg[1:-1]
	    if msg[:6] == "ACTION":
	        self.logfile.local_msg (recvr, prefixes.Me % fromnick, 
		    "%s" % self.unbuc(msg[7:]))
	    if recvr == "private":
		# private CTCP
		if msg[:8] == "DCC SEND":
		    self.limited_send ("NOTICE %s :Not accepting files" % fromnick)
		if msg[:7] == "VERSION":
		    self.limited_send ("NOTICE %s :\x01VERSION tilkIRClog, ultimate irc logger (http://irclog.tilk.geos.pl)\x01" % fromnick)
		if msg[:4] == "PING":
		    self.limited_send ("NOTICE %s :\x01%s\x01" % (fromnick, msg))
		if msg[:5] == "ADMIN":
		    self.ADMINCTCP(msg,event)

    # NOTICE
    def NOTICE(self,event):
	msg = event["params"][1]

	if event.has_key("prefix"):
	    fromnick = event["prefix"][0]
	else:
	    fromnick = self.server

	if fromnick in irclog_config.ignorelist:
	    return

	self.logfile.local_msg ("private", prefixes.Notc % fromnick, 
	    self.unbuc(msg))

    # JOIN 
    def JOIN(self,event):
	channame = event["params"][0].lower()
	thenick = event["prefix"][0]
	if self.ournick(thenick):
	    if self.act_banlist.has_chan(channame):
		self.act_banlist.del_chan(channame)
	    self.act_nicklist.new_chan(channame)
	    self.act_largestnick.new_chan(channame)
	    self.act_chanlist.new_chan(channame)
	    self.services_self_aop()
	    self.socket.writeline("MODE %s" % channame)
	    self.socket.writeline("MODE %s b" % channame)
	    
	self.act_nicklist.new_nick(channame,thenick);
	self.act_largestnick.add(channame,thenick)
	if ((irclog_config.mircformat) and (self.ournick(thenick))):
	    self.logfile.local_msg (channame, prefixes.Join, "Now talking in %s" 
		% channame)
	else:
	    self.logfile.local_msg (channame, prefixes.Join, "%s has joined %s" 
		% (self.gen_host_from_prefix(event["prefix"]), channame))

    # PART
    def PART(self,event):
	channame = event["params"][0].lower()
	partnick = event["prefix"][0]
	if self.act_nicklist.has_chan(channame):
	    self.act_nicklist.del_nick(channame,partnick);
	    if len(partnick) >= self.act_largestnick[channame]:
		self.act_largestnick.recalculate(channame,
		    self.act_nicklist[channame])

	if self.ournick(partnick):
	    self.act_nicklist.del_chan(channame)
	    self.act_largestnick.del_chan(channame)
	    self.act_chanlist.del_chan(channame)
		    
	msg = "%s has left " % self.gen_host_from_prefix(event["prefix"]);
	msg += channame;
	if len(event["params"]) > 1:
	    msg = msg + " (%s)" % self.unbuc(event["params"][1]) 
	self.logfile.local_msg (channame, prefixes.Part, msg)

    # QUIT
    def QUIT(self,event):
	outnick = event["prefix"][0]
	if self.ournick(outnick):
	    raise "leave"
	for chan in self.act_chanlist.list_chans():
	    if not self.act_nicklist.has_nick(chan,outnick):
		continue
	    self.act_nicklist.del_nick(chan,outnick)
	    if len(outnick) >= self.act_largestnick[chan]:
		self.act_largestnick.recalculate(chan,
		    self.act_nicklist[chan])
	    msg = "%s Quit" % self.gen_host_from_prefix(event["prefix"])
	    try:
	        addm = event["params"][0]
		msg = msg + " (%s)" % self.unbuc(addm)
	    except:
		pass			
	    self.logfile.local_msg (chan, prefixes.Part, msg)
	self.check_and_reclaim_nick()

    # KICK
    def KICK(self,event):
	channame = event["params"][0].lower()
	outnick = event["params"][1]
	if self.ournick(outnick):
	    self.act_nicklist.del_chan(channame)
	    self.act_chanlist.del_chan(channame)
	    if channame in irclog_config.channels:
		self.socket.JOIN(channame)
	self.act_nicklist.del_nick(channame,outnick)
	if (irclog_config.mircformat):
	    msg = "%s was kicked by %s" % (outnick,event["prefix"][0])
	else:
	    msg = "%s was kicked by %s" % (outnick, 
		self.gen_host_from_prefix(event["prefix"]))
	if len(event["params"]) > 2:
	    msg = msg + " (%s)" % self.unbuc (event["params"][2])
	self.logfile.local_msg (channame, prefixes.Part, msg)
		    
    # BANLIST
    def BANLIST(self,event):
	if irclog_config.mircformat: return;
	channame = event["params"][0].lower()
	message = "Ban (%s)" % event["params"][1]
	if len(event["params"]) > 2:
	    message = message + " by %s" % event["params"][2]
	if len(event["params"]) > 3:
	    message = message + "on %s" % (time.asctime(time.localtime(
		int(event["params"][3]))))
	self.logfile.local_msg (channame, prefixes.Info, message)

    # CHANNELMODEIS
    def CHANNELMODEIS(self,event):
	if irclog_config.mircformat: return;
	channame = event["params"][0].lower()
	message = "Channel modes:"
	for mode in event["params"][1:]:
	    message = message + " +" + mode[1]
	    if mode[2]:
	      message = message + " %s" % mode[2]
	    if mode[0]:
	      message = message + " (%s)" % mode[0]
	self.logfile.local_msg (channame, prefixes.Info, message)

    # NAMES
    def NAMES(self,event):
	channame = event["params"][1].lower()
	message = "Users on channel:"
	for tuser in event["params"][2:]:
	    addon = " "
	    try:
	        if tuser[1] == "op":
		    addon = addon + "@"
		elif tuser[1] == "voice":
		    addon = addon + "+"
	    except:
		pass
	    message = message + addon + tuser[0]
	    self.act_nicklist.new_nick(channame,tuser[0],addon[-1])
	    self.act_largestnick.add(channame, tuser[0])

	if not self.quiet_names.has_key(channame):
	    if not irclog_config.mircformat:
		self.logfile.local_msg (channame, prefixes.Info, message)
	else:
	    del self.quiet_names[channame]

    # ENDOFNAMES
    def ENDOFNAMES(self,event):
	channame = event["params"][0].lower()
#	self.logfile.local_msg (event["params"][0], prefixes.Info, 
#	    "Synchronized to channel")

    # INVITE ONLY
    def INVITEONLY(self,event):
	chan = event["params"][0].lower()
	if not irclog_config.use_services:
	    return
	if not irclog_config.serv_privs.has_key(chan):
	    return
	if irclog_config.serv_privs[chan] >= 5:
	    self.socket.CHANSERV("INVITE %s" % chan)

    # BANNED FROM CHANNEL
    def BANNED(self,event):
	chan = event["params"][0].lower()
	if not self.act_banlist.has_chan(chan):
	    self.act_banlist.new_chan(chan)
	    if not irclog_config.mircformat: 
	        self.logfile.local_msg (chan, prefixes.Info, 
		    "Banned from channel, will try to rejoin")
	if not irclog_config.use_services:
	    return
	if not irclog_config.serv_privs.has_key(chan):
	    return
	if irclog_config.serv_privs[chan] >= 5:
	    self.socket.CHANSERV("UNBAN %s" % chan)
	    self.socket.CHANSERV("INVITE %s" % chan)

    # NICK CHANGE
    def NICK(self,event):
	oldnick = event["prefix"][0]
	newnick = event["params"][0]

	if self.ournick(oldnick):
	    self.nick = newnick

	mesg = "%s is now known as %s" % (oldnick, newnick);

	for chan in self.act_chanlist.list_chans():
	    if not self.act_nicklist.has_nick(chan,oldnick):
		continue
	    self.act_nicklist.change_nick(chan,oldnick,newnick)
	    if max(len(oldnick),len(newnick)) >= self.act_largestnick[chan]:
		self.act_largestnick.recalculate(chan,self.act_nicklist[chan])
	    self.logfile.local_msg (chan, prefixes.Info, mesg)

	self.check_and_reclaim_nick()

    # MODE CHANGE
    def MODE(self,event):
	recvr = event["params"][0].lower()
	msg = "%s sets mode:" % event["prefix"][0]

	reNames = None
	reOp = None

	if self.ournick(recvr):
	    recvr = "private"

	bmsg = msg[:]

	for param in event["params"][1:]:
	    if msg[-1:] != ':':
	    	msg = msg + ","
	    msg = msg + " %s%s" % (param[0], param[1])
	    if param[3]:
	    	msg = msg + " %s" % param[3]
	    if param[2]:
	    	msg = msg + " (%s)" % param[2]
	    if param[1] in "ov":
		self.act_nicklist.change_mode(recvr, param[3], "%s%s" % 
		    (param[0],param[1]))
		if param[0] == "-" and param[1] == "o":
		    reNames = 1
		    if self.ournick(param[3]):
		        reOp = 1

	if irclog_config.mircformat:
	    msg = bmsg + " ";
	    xx = event["paramstring"][1:]
	    msg += xx[xx.find(" ")+1:]
	
	if reNames:
	    self.socket.NAMES(recvr)
	    self.quiet_names[recvr] = 1
	
	if reOp:
	    self.services_self_aop()
		    
	self.logfile.local_msg(recvr, prefixes.Info, msg)

    # INVITE
    def INVITE(self,event):
	chan = event["params"][1].lower()
	if chan in irclog_config.channels and not self.act_chanlist.has_chan(chan):
	    self.socket.JOIN(chan)
	else:
	    self.logfile.local_msg ("private", prefixes.Info, 
		"Invalid invite to %s from %s" % 
		(chan, self.gen_host_from_prefix(event["prefix"])))
	    self.limited_send ("NOTICE %s :Access denied" % event["prefix"][0])

    # ERROR
    def ERROR(self,event):
	mtext = "Error: %s" % event["params"][0];
	if irclog_config.mircformat:
	    self.logfile.local_msg("private", prefixes.Elog, mtext)
	else:
	    self.logfile.global_msg(prefixes.Elog, mtext)

