#    $Id: irclog_support.py,v 1.8 2002/01/27 21:38:51 tilk Exp $
#    tilkIRClog
#    Copyright (C) 2001  Marek "Tilk" Materzok
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import string,re
import copy

class ChanList:
    def __init__(self):
	self.list = {}
	self.default = 1

    def __getitem__(self,chan):
	chan = chan.lower()
	if not self.has_chan(chan):
	    self.new_chan(chan)
	return self.list[chan]

    def has_chan(self,chan):
	chan = chan.lower()
	return self.list.has_key(chan)

    def new_chan(self,chan):
	chan = chan.lower()
	self.list[chan] = copy.deepcopy(self.default)

    def del_chan(self,chan):
	chan = chan.lower()
	if self.has_chan(chan):
	    del self.list[chan]

    def list_chans(self):
	return self.list.keys()

class NickList(ChanList):
    def __init__(self):
	ChanList.__init__(self)
	self.default = {}
	
    def has_nick(self,chan,nick):
	chan = chan.lower()
	nick = nick.lower()
	if not self.has_chan(chan):
	    return None
	return self.list[chan].has_key(nick)

    def new_nick(self,chan,nick,symb=""):
	chan = chan.lower()
	nick = nick.lower()
	if not self.has_chan(chan):
	    self.new_chan(chan)
	self.list[chan][nick] = symb

    def del_nick(self,chan,nick):
	chan = chan.lower()
	nick = nick.lower()
	if not self.has_chan(chan):
	    self.new_chan(chan)
	if self.has_nick(chan,nick):
	    del self.list[chan][nick]

    def change_nick(self,chan,oldnick,newnick):
	chan = chan.lower()
	oldnick = oldnick.lower()
	newnick = newnick.lower()
	if not self.has_chan(chan):
	    self.new_chan(chan)
	if not self.has_nick(chan,oldnick):
	    self.new_nick(chan,newnick)
	    return
	md = self.list[chan][oldnick]
	self.del_nick(chan,oldnick)
	self.new_nick(chan,newnick,md)

    def change_mode(self,chan,nick,mode):
	chan = chan.lower()
	nick = nick.lower()

	if not self.has_chan(chan):
	    self.new_chan(chan)
	if not self.has_nick(chan,nick):
	    return
	if len(mode) != 2:
	    return

	char = ""
	if mode[1] == "v":
	    char = "+"
	if mode[1] == "o":
	    char = "@"
	if char == "":
	    return
	
	if mode[0] == "+" and char not in self.list[chan][nick]:
	    self.list[chan][nick] = self.list[chan][nick] + char
	elif mode[0] == "-" and char in self.list[chan][nick]:
	    self.list[chan][nick] = self.list[chan][nick].replace(char,"")

    def return_mode(self,chan,nick):
	chan = chan.lower()
	nick = nick.lower()
	if not self.has_chan(chan):
	    self.new_chan(chan)
	if not self.has_nick(chan,nick):
	    return ""
	if "@" in self.list[chan][nick]:
	    return "@"
	elif "+" in self.list[chan][nick]:
	    return "+"
	return ""

class LargestNick(ChanList):
    def __init__(self):
	ChanList.__init__(self)
	self.default = 1

    def recalculate(self,chan,nlist):
	chan = chan.lower()
	if not self.has_chan(chan):
	    self.new_chan(chan)
	self.list[chan] = 1
	for nick in nlist.keys():
	    self.add(chan,nick)

    def add(self,chan,nick):
	chan = chan.lower()
	if not self.has_chan(chan):
	    self.new_chan(chan)
	lnn = len(nick)
	if lnn > self.list[chan]:
	    self.list[chan] = lnn

class HostMask:
    def __init__(self):
	self.cache = {}

    def compare(self,host,hostmask):
	host = host.lower()
	hostmask = hostmask.lower()

	if not self.cache.has_key(hostmask):
	    hostre = string.replace(hostmask,".","\.")
	    hostre = string.replace(hostre,"*",".*")
	    hostre = "^" + string.replace(hostre,"?",".") + "$"
	    self.cache[hostmask] = re.compile(hostre)

	if self.cache[hostmask].match(host):
	    return 1
	else:
	    return None
