;#############################################################
;# TkLauncher 0.32 - a simple desktop launcher for GNU/Linux #
;#############################################################

;# Copyright (C) 2016 Pasquale Frega
;# All rights reserved

;# Released under the simplified BSD license

;# last edit: 26-Jun-2018

;# begin

;# Read global settings if present

if {[file exists ~/.wishrc]} {
	catch {source ~/.wishrc}
}

;# Hide the main window

wm iconify .
wm withdraw .

;# Declare and set the main variables to initial values

variable background {darkslateblue}
variable foreground {white}
variable active_foreground {cyan}
variable gadget_color {darkslateblue}
variable show_at_startup {true}
variable height 48
variable pad_x 7
variable quick_launch
variable font_to_use {helvetica 10}

;# Check command line arguments

if {$argc != 0} {
	switch [lindex $argv 0] {
		{-r} {
			exec pkill -fo [file tail [info nameofexecutable]]
			exec [file tail [info nameofexecutable]] &
			exit 0
		}
		{-l} {
			puts "TkLauncher version 0.32\n\nCopyright (c) 2016, Pasquale Frega\n\nAll rights reserved.\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions are met:\n\n1. Redistributions of source code must retain the above copyright notice, this\n   list of conditions and the following disclaimer.\n2. Redistributions in binary form must reproduce the above copyright notice,\n   this list of conditions and the following disclaimer in the documentation\n   and/or other materials provided with the distribution.\n\nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND\nANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\nWARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\nDISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR\nANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\n(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\nLOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND\nON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\nSOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
			exit 0
		}
		default {
			puts "Usage: [file tail [info nameofexecutable]] \[option\]\nOption could be:\n\t-r\tReset process\n\t-l\tShow version and license"
			exit 0
		}
	}
}

;# Show the error message

proc ErrMsg {} {
	tk_messageBox -icon error -message {PROGRAM ERROR}
	exit 1
}

;# Create the configuration file in home directory if it does not exist

if {![file exist ~/.tklauncherrc]} {
	if {[catch {file copy [file dirname [file dirname [info nameofexecutable]]]/share/tklauncher/tklauncherrc ~/.tklauncherrc}]} {
		ErrMsg
	}
}

;# Create log file

if {[catch {open /tmp/tklauncher.log w} chid]} {
	ErrMsg
} else {
	close $chid
}

;# If bad configuration file

proc BadConf {} {
	tk_messageBox -icon warning -message {Check ~/.tklauncherrc}
	exit 0
}	

;# Load package Img, only PNG and XPM format

if {[catch {package require img::png; package require img::xpm}]} {
	tk_messageBox -icon error -message {Could not load package Img};	
	exit 1
}

;# Set the options from the configuration file and create the launchers

if {![catch {open ~/.tklauncherrc} chid]} {
	set launcher_number 0;	
	while {![eof $chid]} {
		set got_list [gets $chid]
		switch [lindex $got_list 0] {
			{Background} {
				set background [lindex $got_list 1]
			}
			{Foreground} {
				set foreground [lindex $got_list 1]
			}
			{ActiveForeground} {
				set active_foreground [lindex $got_list 1]
			}
			{Gadget} {
				set gadget_color [lindex $got_list 1]
			}
			{ShowAtStartup} {
				if {[string is boolean [lindex $got_list 1]]} {
					set show_at_startup [lindex $got_list 1]
				} else {
					set show_at_startup {true}
				}
			}
			{Height} {
				if {[string is integer [lindex $got_list 1]]} {
					set height [lindex $got_list 1]
				} else {
					BadConf
				}
			}	
			{PadX} {
				if {[string is integer [lindex $got_list 1]]} {
					set pad_x [lindex $got_list 1]
				} else {
					BadConf
				}
			}
			{QuickLaunch} {
				set quick_launch [lindex $got_list 1]
			}
			{FontToUse} {
				set font_to_use [lindex $got_list 1]
			}
			{Launcher} {
				set launcher($launcher_number) [lindex $got_list 1]
				if {[catch {toplevel .$launcher($launcher_number) -borderwidth 1 -relief raised -background $background}]} {
					BadConf
				}
				wm overrideredirect .$launcher($launcher_number) yes
				raise .$launcher($launcher_number)
				wm withdraw .$launcher($launcher_number)
				set icon_number 0
				set to_grid {grid}
				while {![string equal [lindex $got_list 0] {End}]} {
					set got_list [gets $chid]
					if {[string equal [lindex $got_list 0] {Icon}]} {
						if {[catch {button .$launcher($launcher_number).$icon_number -image [image create photo -file [lindex $got_list 1] -height $height] -command "catch {exec [lindex $got_list 2] 2>>/tmp/tklauncher.log &}" -font $font_to_use -text [lindex $got_list 3] -compound top -borderwidth 0 -pady 1 -padx $pad_x -highlightbackground $background -background $background -activebackground $background -foreground $foreground -activeforeground $active_foreground}]} {
							BadConf
						}
						lappend to_grid .$launcher($launcher_number).$icon_number
						incr icon_number
					}
				}
				eval "$to_grid -sticky news"
				update idletasks
				wm geometry .$launcher($launcher_number) +[expr {[winfo screenwidth .] - [winfo width .$launcher($launcher_number)] - 18}]+[expr {[winfo screenheight .] - ($height + 23)}]
				incr launcher_number
			}
		}
	}	
	close $chid
} else {
	ErrMsg
}

;# Create and set the gadget window

if {[catch {toplevel .gadget -relief raised -borderwidth 1 -background $gadget_color}]} {
	BadConf
}
wm overrideredirect .gadget yes
raise .gadget
wm geometry .gadget 18x[expr {$height + 23}]+[expr {[winfo screenwidth .] - 18}]+[expr {[winfo screenheight .] - ($height + 23)}]
bind .gadget <Double-1> {
	if {![string equal [wm state .$selected_launcher] {withdrawn}]} {
		wm withdraw .$selected_launcher
	} else {
		wm deiconify .$selected_launcher
	}
}
bind .gadget <ButtonPress-3> {
	catch {exec {*}$quick_launch 2>>/tmp/tklauncher.log &}
}

;# Create the icon and the button of the launcher menu

set lmenu_icon [image create photo -data {/* XPM */
static char * lmenu_xpm[] = {
"14 15 4 1",
" 	g None",
".	g #000000",
"+	g #A9A9A9",
"@	g #767676",
"..............",
".++++++++++++.",
".+.++++++++.+.",
".+..++++++..+.",
".+@..++++..@+.",
".++@..++..@++.",
".+++@....@+++.",
".++++@..@++++.",
".+++++@@+++++.",
".++++++++++++.",
".+..........+.",
".+@@@@@@@@@@+.",
".++++++++++++.",
".++++++++++++.",
".............."};
}]
menubutton .gadget.lmenu_button -direction left -image $lmenu_icon -relief raised -menu .gadget.lmenu_button.lmenu
bind .gadget.lmenu_button <ButtonRelease-1> {
	.gadget.lmenu_button.lmenu entryconfigure end -state active
}

;# Create the launcher menu

proc LMenuCommand {launcher} {
	global selected_launcher
	
	if {![string equal [wm state .$selected_launcher] {withdrawn}]} {
		wm withdraw .$selected_launcher
	}
	set selected_launcher $launcher
	wm deiconify .$selected_launcher
}
menu .gadget.lmenu_button.lmenu -background white -activebackground black -foreground black -activeforeground white -tearoff 0
.gadget.lmenu_button.lmenu add command -font $font_to_use -label {About} -command {tk_messageBox -title {About} -message "TkLauncher 0.32\n\nCopyright (C) 2016 Pasquale Frega\n\nAll rights reserved\n\npasquale_frega@tiscali.it\n\nReleased under the simplified\nBSD license"}
.gadget.lmenu_button.lmenu add separator
for {set idx [expr {$launcher_number - 1}]} {$idx >= 0} {incr idx -1} {
	.gadget.lmenu_button.lmenu add command -font $font_to_use -label $launcher($idx) -command "LMenuCommand $launcher($idx)"
}

;# Pack the launcher menu

pack .gadget.lmenu_button -side bottom

;# Show at startup if chosen

set selected_launcher $launcher(0)
if {$show_at_startup} {
	wm deiconify .$selected_launcher
}

;# end
