/*

  tMERLIN
  version 0.3

  Copyright (C) 2010-2012  Lukas Hofmann <lhfloss@gmx.de>

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  
*/

#include <stdio.h>
#include <ncursesw/curses.h>


short int table[9];
short int tind = 0;


draw_table()
{
  chtype symbols[2] = { '-', ACS_DIAMOND };
  move(0, 0);
  color_set(3, 0);
  printw(" tMerlin\n\n");
  mvhline(1,0,ACS_HLINE, 9);
  move(3, 1);

  for (tind=0; tind<9; tind++)
    {
      color_set(table[tind] + 1, 0);
      printw(" ");
      addch(symbols[table[tind]]);
      if (!((tind + 1) % 3)) { printw("\n "); }
    }
}

int countdown_check(short int start_pos)
{
  return((start_pos == 0) ? table[0] : table[start_pos] && countdown_check(start_pos - 1));
}

set_new_status(short int switch_index)
{
  if (switch_index >= 0 && switch_index <=8)
    {
      table[switch_index] = ! table[switch_index];
    }
}

switch_status(short int switch_index)
{
  set_new_status(switch_index);
  switch (switch_index)
    {
    case 1: case 7:
      set_new_status(switch_index - 1);
      set_new_status(switch_index + 1);
      break;
    case 3: case 5:
      set_new_status(switch_index - 3);
      set_new_status(switch_index + 3);
      break;
    case 0: case 8:
      set_new_status(switch_index + 4);
      set_new_status(switch_index - 4);
    case 4:
      set_new_status(switch_index - 1);
      set_new_status(switch_index + 1);
      set_new_status(switch_index - 3);
      set_new_status(switch_index + 3);
      break;
    case 2:
      set_new_status(switch_index - 1);
      set_new_status(switch_index + 3);
      set_new_status(switch_index + 2);
      break;
    case 6:
      set_new_status(switch_index + 1);
      set_new_status(switch_index - 3);
      set_new_status(switch_index - 2);
      break;
    }
}

int check_for_input_data()
{
  int chars=0;

  nodelay(stdscr, TRUE);
  while (getch() != -1)
    chars++;
  nodelay(stdscr, FALSE);
  return(chars);
}

main()
{
  int selected_number;
  char user_input, play_again;

  initscr();
  cbreak();
  noecho();
  curs_set(0);
  
  start_color();
  init_pair(1, COLOR_YELLOW, COLOR_BLACK);
  init_pair(2, COLOR_RED, COLOR_BLACK);
  init_pair(3, COLOR_GREEN, COLOR_BLACK);

  color_set(3, 0);
  printw(" tMerlin\n\n");
  mvhline(1,0,ACS_HLINE, 9);
  color_set(1, 0);
  move(3,1);
  printw(" q w e\n  a s d\n  y x c\n\n");
  color_set(3, 0);
  printw("Welcome to tMerlin.\n");
  color_set(1, 0);
  printw("Use the keys above to switch the corresponding cell's state.\nPress ESC to quit at any time.\nPress h to get copyright information.\n\nPress any key to start.\n");
  getch();

  wclear(stdscr);

  srand(time(NULL));  
  do
    {
      for (tind=0; tind<9; tind++)
	{
	  table[tind] = (rand()%2);
	}

      draw_table();
      refresh();

      while (!(countdown_check(8)))
	{
	  user_input = getch();

	  if (user_input == 'q') { selected_number=0; }
	  else if (user_input == 'w') { selected_number=1; }
	  else if (user_input == 'e') { selected_number=2; }
	  else if (user_input == 'a') { selected_number=3; }
	  else if (user_input == 's') { selected_number=4; }
	  else if (user_input == 'd') { selected_number=5; }
	  else if (user_input == 'y') { selected_number=6; }
	  else if (user_input == 'x') { selected_number=7; }
	  else if (user_input == 'c') { selected_number=8; }
	  else if ((user_input == 27 ) && (check_for_input_data() < 2)) { endwin(); return(0); }
	  else if (user_input == 'h')
	    {
	      wclear(stdscr);
	      color_set(3, 0);
	      printw(" tMerlin\n\n");
	      mvhline(1,0,ACS_HLINE, 9);
	      color_set(3, 0);
	      printw("\nCopyright (C) 2010-2012  Lukas Hofmann <lhfloss@gmx.de>\n");
	      color_set(1, 0);
	      printw("This program comes with ABSOLUTELY NO WARRANTY.\nThis is free software, and you are welcome to redistribute it\nunder certain conditions; Read the file COPYING for details.\n");
	      selected_number=1337;
	      getch();
	    }
	  else selected_number=1337;
	  switch_status(selected_number);
	  wclear(stdscr);
	  draw_table();
	  refresh();
	}
      color_set(3, 0);
      printw("\nYou win!\n");
      color_set(1, 0);
      printw("Press a key to play again.\n");
      color_set(0, 0);
      play_again = (!((getch() == 27) && (check_for_input_data() < 2)));
      wclear(stdscr);
    } while (play_again);

  endwin();
}
