<?php
function _addAllPictures(&$tof,$vars) {
	addAllPictures(
		$tof,
		$vars['RollID'], 
		$vars['ParentTopicID'], 
		$vars['Groups']);
}

function addAllPictures(&$tof,$rollID, $parentTopicID, $groups) {
	$nb_pict = 0;
	if ($handle = opendir($tof->basePath . $rollID)) {
		while ($file = readdir($handle)) {
			/* if not thumb */
			if (!ereg('(.+)'.$tof->thumb_suffix.'$', $file)) {
				/* if is picture */
				if (ereg('(.+)'.$tof->picture_suffix.'$', $file, $arr)) {
					/* add picture if not already present */
					$frameID = $arr[1];
					if (!file_exists($tof->basePath.$rollID.'/'.
					$frameID.$tof->orig_suffix) && 
						!$tof->ct->pictureExists($rollID, $frameID))
					{
						$picture = array( 'RollID' => $rollID, 
										  'FrameID' => $frameID,
										  'Description' => '',
										  'Owner' => $tof->uid);
						$tof->ct->addPicture($picture,
						array($parentTopicID),
						$groups);
						$tof->log(
							sprintf(_('Added picture %s with frame id %s'),
									$file,$frameID));
						$nb_pict += 1;
					}
				} else if (ereg('(.+)'.$tof->orig_suffix.'$',
								$file, $arr)) {
					$frameID = $arr[1];
					$tof->log(
						sprintf(_('Added picture %s with frame id %s'),
								$file,$frameID));
					$tof->uploadPicture(
						$tof->basePath.$rollID.'/'.$file,$rollID,$frameID,
						$tof->basePath.$rollID,
						$parentTopicID, "", $groups);
					$nb_pict += 1;
				}
			}
		}
		closedir($handle);
	} else {
		printf(_("could not open directory %s"),$tof->basePath . $rollID);
	}
}
?>