<?php
function _addGroup(&$tof,$vars) {
	addGroup(
		$tof,
		array('Name' => $vars['groupName'],
			  'Owner' => $tof->uid),
		$vars['groupUsers']);
}

/**
 * Create a new group
 * @param group an array representing the group
 * @param users an array of userID to put in the new group
 */
function addGroup(&$tof,$group,$users) {
	$name = $group['Name'];
	if ($name == '') {
		$tof->error(_("Group name cannot be empty."));
		return;
	}
	if ($tof->ct->getGroupByName($name)) {
		$tof->warn(
			sprintf(_("A group named \"%s\" already exists."),$name));
	}
	$tof->ct->addGroup($group,$users);
}
?>