<?php
function _deletePicture(&$tof,$vars) {
	$tof->deletePicture($vars['PictureID'],$vars['DeleteFiles']);
}

function deletePicture(&$tof,$pictureID,$deleteFiles) {
	$picture = $tof->ct->getPicture($pictureID);
	if (!is_array($picture)) {
		$tof->error(sprintf(_("Picture %s not found !!!"),$pictureID));
		return;
	}
	if ($picture['Owner'] != $tof->uid) {
		$tof->error(_('You cannot delete a picture that you do not own'));
		return;
	}
	$tof->ct->deletePicture($pictureID);
	if ($deleteFiles) {
		$tof->deleteFiles($picture);
	}
}

function deleteFiles(&$tof,$picture) {
	$tof->increaseDiskUsage(
		$picture['Owner'],
		- $tof->getPictureDiskUsage($picture));
	unlink($tof->getOrigFilename($picture));
	unlink($tof->getPictureFilename($picture));
	unlink($tof->getThumbFilename($picture));
}
?>