<?php
function updateDiskUsage(&$tof,$userID = false) {
	if ($userID === false) {
		// compute for all users
		echo "updateDiskUsage<br>";
		$pictures = $tof->ct->getPictures('Owner,PictureID,RollID,FrameID');
		$diskUsages = array();
		$total = 0;
		$tof->log(count($pictures)." pictures");
		foreach($pictures as $picture) {
			$owner = $picture['Owner'];
			$du = $tof->getPictureDiskUsage($picture);
			$total += $du;
			$tof->log($picture['PictureID']."($owner) -> $du");
			if (array_key_exists($owner,$diskUsages)) {
				$diskUsages[$owner]['DiskUsage'] += $du ;
			} else {
				$diskUsages[$owner] = 
					 array('UserID' => $owner,
						   'DiskUsage' => $du);
			}
		}
		$tof->log("Total = ".makeSizeString($total));
		$tof->ct->updateUsers($diskUsages);
	} else {
		// compute for a single user
		$user = $tof->ct->getUser($userID);
		$tof->log(
			sprintf(_('Previous disk usage: %s'),
					makeSizeString($user['DiskUsage'])));
		$diskUsage = $tof->getDiskUsage($userID);
		$tof->log(
			sprintf(_('New disk usage: %s'),
					makeSizeString($diskUsage)));
		$tof->ct->updateUser($userID,array('DiskUsage' => $diskUsage));
		if ($tof->uid == $userID) {
			$tof->setUser($userID);
		}
	}
}

function increaseDiskUsage(&$tof,$userID, $size) {
	$user = $tof->ct->getUser($userID);
	$tof->ct->updateUser(
		$userID,
		array('DiskUsage' => $user['DiskUsage'] + $size));
}


/**
 * Returns disk usage for a user
 * @param userID ID of user to get disk usage
 */
function getDiskUsage(&$tof,$userID) {
	require_once("actions/file_size.php");
	$diskUsage = getFileSizes($tof,$tof->ct->getPicturesOwnedBy($userID),true);
	return $diskUsage['total'];
}

function getPictureDiskUsage(&$tof,$picture) {
	require_once("actions/file_size.php");	  
	$diskUsage = 
		 $tof->getFilesSize(
			 array(
				 $tof->getThumbFilename($picture),
				 $tof->getPictureFilename($picture),
				 $tof->getOrigFilename($picture)));
	return array_sum($diskUsage);
}
?>