<?php
/**
 * Returns summary of file sizes for a set of pictures.
 * @param pictures a set of pictures or picture IDs
 * @param blocks if true, account filesystem blocks size instead of filesize.
 */
function getFileSizes(&$tof,$pictures,$blocks=false) {
	$thumbSize = 0;
	$normalSize = 0;
	$bigSize = 0;

	foreach($pictures as $picture) {
		if (!is_array($picture)) {
			$pictureID = $picture;
			$picture = $tof->ct->getPicture($picture,$tof->uid);
		}
		if ($picture) {
			$filename = $tof->getThumbFilename($picture);
			$thumbSize += getFileSize($filename,$blocks);

			$filename = $tof->getPictureFilename($picture);
			$normalSize += getFileSize($filename,$blocks);

			$filename = $tof->getOrigFilename($picture);
			$bigSize += getFileSize($filename,$blocks);
		} else {
			$tof->warn(
				sprintf(_('Omitted picture #%s: access denied'),
						$pictureID));
		}
	}
	return array('thumb' => $thumbSize,
				 'normal' => $normalSize,
				 'fullsize' => $bigSize,
				 'total' => $thumbSize+$normalSize+$bigSize);
}

function getFileSize($filename,$blocks) {
	if (file_exists($filename)) {
		if ($blocks) {
			$stats = stat($filename);
			if ($stats['blocks']!=-1 && $stats['blksize']!=-1)
				return $stats['blocks'] * $stats['blksize'];
			$du = `du -k $filename`;
			if (ereg("^([0-9]+)\s*.*$",$du,$match)) 
				return $match[1] * 1024;
			else {
				return filesize($filename);
			}
		} else {
			return filesize($filename);
		}
	} else {
		return 0;
	}
}

function getFilesSize(&$tof,$filenames) {
	$sizes = array();
	  
	$filenames = join('" "',$filenames);
	$tof->debug("du -k \"$filenames\"");
	exec("du -k \"$filenames\"",$out,$ret);
	foreach($out as $du) {
		if (ereg("^([0-9]+)\s*(.*)$",$du,$match)) 
			$sizes[$match[2]] = $match[1] * 1024;
	}
	return $sizes;
}

?>