<?php
function resizePicture(&$tof,$src,$dest,$width,$height) {
	$tof->debug("resizePicture($src,$dest,$width,$height)");
	exec("convert -geometry ${width}x${height} \"$src\" \"$dest\"",$output,$status);
	//$output = shell_exec("convert -geometry $widthx$height \"$src\" \"$dest\" 2>&1 ");
	//$this->log($output);
	if ($status) {
		$tof->error(_("failed to resize")." $src -> $dest ($width*$height)");
		//$this->error(implode("<br>",$output));
		return false;
	}
	return true;
}

/**
 * Create thumb and medium size picture from orig if it exists, or
 * thumb from medium size.
 * @param picture create thumb for this picture
 * @param overwrite wether to overwrite existing files
 */
function createThumb(&$tof,$picture,$overwrite=false) {
	$orig = $tof->getOrigFilename($picture);
	if (file_exists($orig)) {
		$filename = $tof->getPictureFilename($picture);
		if ($overwrite || !file_exists($filename)) {
			if (!resizePicture(
				$tof,
				$orig,$filename,
				$tof->pictureWidth,$tof->pictureHeight)) {
				return false;
			}
		}
	} else {
		$bad = $orig;
		$orig = $tof->getPictureFilename($picture);
		$tof->warn(sprintf(_("No orig picture %s ,trying %s"),$bad,$orig));
	}
    
	$filename = $tof->getThumbFilename($picture);
	if ($overwrite || !file_exists($filename)) {
		if (!resizePicture(
			$tof,
			$orig,$filename,
			$tof->thumbSize,$tof->thumbSize)) {
			return false;
		}
	}
}
?>