<?php
function _updateDates(&$tof,$vars) {
	$overwrite = $vars['Overwrite'];
	$pictures = $tof->ct->getPictures('PictureID,Date,RollID,FrameID');
	foreach($pictures as $picture) {
		  $tof->updateDate($picture,$overwrite);
	}
}

function updateDate(&$tof,$picture, $overwrite) {
	if (!$picture['Date'] || $overwrite) {
		$date = $tof->readExifDate($tof->getOrigFilename($picture));
		if (!$date) 
			$date = $tof->readExifDate($tof->getPictureFilename($picture));
		if ($date) {
			$tof->log(
				"Found time for ".$picture['PictureID'].
				" in $file: $date");
			$picture['Date'] = $date;
			$tof->ct->setDate($picture);
		}

		//$tof->show("No time found for: ".$tof->getOrigFilename($picture)."<br>");
	} else {
		$tof->log(
			sprintf(_("Skipping %s, current date=%s"),
					$tof->getOrigFilename($picture),
					$picture['Date']));
	}
}
?>