<?php
function addUser(&$tof,$user,$notifyUser) {
	if ($tof->uid == 1 || $tof->upload) {
		if ($tof->ct->getUserByName($user['Username'])) {
			$tof->error(sprintf(_('There\'s already a user with the login %s'),$user['Username']));
			return;
		}
		$tof->ct->addUser($user);
		if ($notifyUser) {
			if ($user['Email']=='') {
				$tof->warn(
					sprintf(_('Mail not sent to user %s since no email address was provided'),
							$user['Username']));
			} else {
				$from = $tof->user['email'];
				$body = sprintf(_("%s has created an account for you on %s\n".
								  "This means that you can identify yourself ".
								  "and see some restricted photos\n".
								  "depending on the groups you belong to.\n".
								  "Your login is \"%s\" and your password is \"%s\".\n"),
								$tof->user['name'],
								$tof->homeURL,
								$user['Username'],
								$user['Password']);
				if (!mail($user['Email'],_("Your photo album account"),$body))
					$tof->error(sprintf(_('Failed to send mail to %s'),$user['Email']));
			}
		}
	} else {
		$tof->error(_("Your are not allowed to create users"));
	}
}

function deleteUser(&$tof,$userID,$removePictures,$deleteFiles) {
	if ($tof->isAdmin) {
		if ($deleteFiles) {
			$pictures = $tof->ct->getPicturesOwnedBy($userID);
			foreach($pictures as $picture) {
				$tof->deleteFiles($picture);
			}
		}
		$tof->ct->deleteUser($userID,$removePictures);
		$tof->log(sprintf(_('User %s deleted'),$userID));
	} else {
		$tof->error(sprintf(_('User %s not deleted: only the administrator is allowed to do this'),$userID));
	}
}

?>