<?php // -*- mode: php -*-
/*
 * Session Management for PHP3
 *
 * Copyright (c) 1998,1999 NetUSE GmbH
 *                    Boris Erdmann, Kristian Koehntopp
 * Copyright (c) 1999 Internet Images srl
 *                    Massimiliano Masserelli
 *
 */ 

define(NOT_LOGGED_IN,1);
define(LOGGED_IN,2);
define(LOGIN_IN_PROGRESS,3);

class Auth {
    var $classname = "Auth";
    var $persistent_slots = array("auth", "in", "state");
  
    var $lifetime = 15;             ##Max allowed idle time before
                                  ## reauthentication is necessary.
                                  ## If set to 0, auth never expires.
      														 
    var $magic = "";                ## Used in uniqid() generation
        
  var $nobody = false;            ## If true, a default auth is created...

  var $cancel_login = "cancel_login"; ## The name of a button that can be 
                                      ## used to cancel a login form

  ## End of user qualifiable settings.

  var $auth = array();            ## Data array
  var $in   = false;
  var $db;
  var $states = array(1=>"NOT_LOGGED_IN",2=>"LOGGED_IN",3=>"LOGIN_IN_PROGRESS");
  ##
  ## Initialization
  ##
  function start() {
    //echo "auth->start()<br>\n";

    $cancel = $this->cancel_login;
    global $sess, $$cancel, $again, $logout;

    ## This is for performance, I guess but I'm not sure if it could
    ## be safely removed -- negro
    ## I suggest that $in should be persistent -- kir
    if (! $this->in) {
      $sess->register("auth");
      $this->in = true;
    }
    
    ## back compatibility: if d_c is set, create db object
    if (isset($this->database_class)) {
      $class = $this->database_class;
      $this->db = new $class;
    }


    # Check current auth state. Should be one of
    #  1) Not logged in (no valid auth info or auth expired)
    #  2) Logged in (valid auth info)
    #  3) Login in progress (if $$cancel, revert to state 1)

	$this->print_state('saved');

    if ($again) {
        $this->unauth();  # We have to relogin, so clear current auth info
		$this->set_state(LOGIN_IN_PROGRESS);
		$this->auth_loginform();
		$sess->freeze();
		exit;
    }

	if ($logout) {
		$this->logout();
	}

	if ($this->state==LOGIN_IN_PROGRESS && $$cancel) {
		$this->set_state(NOT_LOGGED_IN);
	}

    switch ($this->state) {
      case LOGGED_IN:
        # Valid auth info
        # Refresh expire info
		$time = time();
		// No need to refresh too often
		if ($time - $sess->changed > 60) {
			//echo "Exp refreshed<br>\n";
			$this->auth["exp"] = $time + (60 * $this->lifetime);
			$sess->freeze();
		} else {
			//echo "Exp(".number_format($sess->changed).")not refreshed ".($time - $sess->changed)." / ".number_format($time)."<br>\n";
		}
        break;
      case LOGIN_IN_PROGRESS:
        # Login in progress, check results and act accordingly
		if ( $uid = $this->auth_validatelogin() ) {
            $this->auth["uid"] = $uid;
			$this->auth["exp"] = time() + (60 * $this->lifetime);
			$this->set_state(LOGGED_IN);
			$sess->freeze();
        } else {
            $this->auth_loginform(true);
			exit();
        }
        break;
      case NOT_LOGGED_IN:
      default:
        # No valid auth info or auth is expired
		if ($this->nobody) {
		    # Authenticate as nobody
			$this->auth["uid"] = "nobody";
			$this->auth["exp"] = 0x7fffffff;
			$this->set_state(LOGGED_IN);
			$sess->freeze();
		} 
    }
  }

  function set_state($new_state) {
      $this->state = $new_state;
	  $this->print_state('new');
  }

  function print_state($prefix) {
      //echo "$prefix state = ".$this->states[$this->state]." / ".$this->auth["uid"]."<br>\n";
  }

  function login_if( $t ) {
    global $sess;
    if ( $t ) {
      $this->unauth();  # We have to relogin, so clear current auth info
	  $this->set_state(LOGIN_IN_PROGRESS);
	  $this->auth_loginform();
	  $sess->freeze();
	  exit;
    }
  }

  function unauth() {
    $this->auth["uid"]   = "";
    $this->auth["perm"]  = "";
    $this->auth["exp"]   = 0;
  }
  

  function logout() {
    global $sess;
    
    $sess->unregister("auth");
    unset($this->auth["uname"]);
    $this->unauth();
  }

  function is_authenticated() {
    if ( $this->auth["uid"] 
        && (($this->lifetime <= 0) || (time() < $this->auth["exp"])) ) {
      return $this->auth["uid"];
    } else {
      return false;
    }
  }
    
  ########################################################################
  ##
  ## Helper functions
  ##
  function url() {
    return $GLOBALS["sess"]->self_url("again=yes");
  }

  function purl() {
    print $GLOBALS["sess"]->self_url();
  }
  
  ##
  ## Authentication dummies. Must be overridden by user.
  ##
  
  function auth_loginform() { ; }

  function auth_validatelogin() { ; }
  
}
?>
