<?php
require_once("./phppdflib/phppdflib.class.php");
require_once("render/layout.php");

// Paper orientation
define(PORTRAIT,'portrait');
define(LANDSCAPE,'landscape');

// Alignment
define(LEFT,0.0);
define(RIGHT,1.0);
define(CENTER,0.5);
define(TOP,1.0);
define(BOTTOM,0.0);

class PDF {
	var $slooze;
	var $pdf;
	var $name;
	var $compression = 0;

	function PDF(&$slooze, $name='', $paperSize = 'a4', $orientation = PORTRAIT) {
		$this->slooze = &$slooze;
		$this->name = $name;
		$this->paperSize = $paperSize;
		$this->orientation = $orientation;
		$this->pdf = new pdffile;
		$this->pdf->set_default('margin', 0);
	}

	function newPage($params = array()) {
		return $this->pdf->new_page($this->paperSize,$params);
	}

	function addPage(&$page,$quality=HIGH,$xoffset=0,$yoffset=0) {
		$pageID = $this->newPage();
		if (is_array($page['Images'])) {
			foreach($page['Images'] as $image) {
				$filename = $this->slooze->getBestFilename($image,$quality);
				$imageID = $this->pdf->jfif_embed_file($filename);
				$box = $image['Box'];
				$this->drawImage(
					$pageID,$imageID,
					$box['left']+$xoffset,$box['bottom']+$yoffset,
					$box['width'],$box['height'],
					$image['halign'],$image['valign']);
			}
		}

		$alignments = array('L'=>'left','R'=>'right','C'=>'center');
		if (is_array($page['Texts'])) {
			foreach($page['Texts'] as $text) {
				$box = $text['Box'];
				$params = array();
				if ($text['Align'])
					$params['align'] = $alignments[strtoupper($text['Align'])];
				if ($text['font'])
					$params['font'] = $text['font'];
				if ($text['size'])
					$params['height'] = $text['size'];
				$this->pdf->draw_paragraph(
					$box['top']+$yoffset,$box['left']+$xoffset,
					$box['bottom']+$yoffset,$box['right']+$xoffset,
					$text['Text'],$pageID,$params);
			}
		}
	}

	/**
	 * Add some pictures, one per page at the maximum size, centered
	 *
	 * @param pictures and array of pictures
	 */
	function addPictures($pictures,$quality=HIGH) {
		foreach($pictures as $picture) {
			$this->addPicture($picture,$quality);
		}
	}

	function addPicture($picture,$quality=HIGH) {
		$filename = $this->slooze->getBestFilename($picture,$quality);
		$pageID = $this->newPage();
		$page = &$this->pdf->objects[$pageID];
		/*
		if ($this->orientation==LANDSCAPE)
			$page['Rotate'] = 90;
		*/
		$imageID = $this->pdf->jfif_embed_file($filename);
		$box = $this->drawImage($pageID,$imageID,0,0,$page['width'],$page['height'],CENTER,CENTER);

		$size = 20;
		$params = array('height'=>$size);
		$x = 0;
		$y = 0;
		if ($box['y']==0) {
			$params['rotation'] = 90;
			$x = $box['x'];
		} else {
			$y = max(0,$box['y']-$size);
		}
		$this->pdf->draw_text(
			$x,$y,$picture['Description'],$pageID,$params);
	}

	function drawImage(
		$pageID,$imageID,$x,$y,$width,$height,
		$halign=CENTER,$valign=CENTER) 
	{
		$page = $this->pdf->objects[$pageID];		
		$imageWidth = $this->pdf->objects[$imageID]['width'];
		$imageHeight = $this->pdf->objects[$imageID]['height'];

		$pos = getImagePos(
			$imageWidth,$imageHeight,
			$x,$y,$width,$height,
			$halign,$valign);

		$placement = 
			 $this->pdf->image_place(
				 $imageID, 
				 $pos['bottom'], $pos['left'], 
				 $pageID, 
				 array('scale'=>$pos['scale']));
		return $pos;
	}

	function generate(&$output,$headers=true) {
		if ($headers) {
			if ($this->name)
				header("Content-Disposition: filename={$this->name}.pdf");
			header("Content-Type: application/pdf");
		}
		$this->pdf->generate($output,$this->compression);
	}

	function toJpeg($density=25) {
		$this->toRaster('jpg',$density);
	}

	function toPng($density=25,$transparent='') {
		$this->toRaster('png',$density,$transparent);
	}

	function toRaster($format,$density,$transparent='') {
		if ($transparent) {
			$transparent = "-transparent '$transparent' ";
		}
		$tmpname = tempnam("/tmp","page");
		$stream = new FileStream($tmpname);
		$this->generate($stream,false);
		$mime = array ('png'=>'image/png',
					   'jpg'=>'image/jpeg');
		header("Content-Type: ".$mime[$format]);
		//header("Cache-Control: private");
		if ($format=='png') {
			passthru("/home/laurent/src/debian/gs-gpl-8.01/bin/gs-gpl".
					 " -q -r${density}x${density} -sDEVICE=pngagray -dNOPAUSE -dBATCH".
					 " -dTextAlphaBits=4 -sOutputFile=- $tmpname");
		} else {
			passthru("convert -density ${density}x${density} ${transparent}pdf:$tmpname $format:-");
		}
		unlink($tmpname);
	}
}
?>