<?php
function showFormDisplayPrefs(&$render,$sort,$mode,$n,$recursive) {
	require_once("render/form_elements.php");

	$render->show('<div class="displayprefs">');
	showFormElementStart($render,false,'post','header');
	if ($sort !== nil) {
		$render->show(_('Sort by '));
		showFormElementSortMethod($render,$sort);
		$render->show('&nbsp;');
	}
	if ($mode !== nil) {
		$render->show(_('Display mode '));
		showFormElementSelect($render,'DisplayMode',$render->modes,$mode);
		$render->show('&nbsp;');
	}
	if ($n !== nil) {
		$render->show(_('Display '));
		showFormElementInteger($render,'Count',$n,3,false);
		$render->show(_(' thumbs per page'));
		$render->show('&nbsp;');
	}
	if ($recursive) {
		showFormElementHidden($render,'RecursiveTopic',0);
		showFormElementCheckBox($render,'RecursiveTopic',$render->recursiveTopic,_('Recurse').'&nbsp;','true','');
	} else {
		showFormElementHidden($render,'RecursiveTopic',$render->recursiveTopic);
	}
	$render->show(_('Author '));
	showFormElementAuthorChooser($render,$render->authorFilter);
	showFormElementEnd($render,_('Display'),'DisplayPrefs');
	$render->show('</div>');
}

function showFormElementSortMethod(&$render,$method = 0) {
	require_once('render/form_elements.php');

	$methodArray = array(SORT_NONE => _('Do not sort'),
						 SORT_AVGRATE => _('Average rate'),
						 SORT_DATE => _('Date'),
						 SORT_DATE_DESC => _('Decreasing Date'),
						 SORT_NBCLICK_DESC => _('Number of access'),
						 SORT_ENTRYDATE_DESC => _('Entry date'),
						 SORT_FRAMEID => _('Frame ID'),
						 SORT_ROLLID => _('Roll'),
						 SORT_TOPICINDEX => _('Album'));
	showFormElementSelect($render,'SortMethod',$methodArray,$method);
}
  
function showFormElementAuthorChooser(&$render,$author) {
	$render->show("<select name=\"AuthorFilter\">");
	$render->show("<option value=\"\">"._('All').'</option>');
	$authors = $render->ct->getAuthors();
	reset($authors);
	while (list($key, $value) = each($authors)) {
		$render->show("<option value=\"" . $value['UserID'] . "\"" . 
					(($value['UserID'] == $author) ? " selected" : "") .
					">" . $value['Name'] . "</option>");
	}
	$render->show('</select>');
}
?>