<?php

/** show form start */
function showFormElementStart(&$render,$selfURL=false,$method="post",$class="",$id="", $target="") {
	if ($selfURL) {
		showFormElementStart2($render,$render->selfURL(),$method,$class,$id,$target);
	} else {
		showFormElementStart2($render,$render->actionAndViewURL(),$method,$class,$id,$target);
	}
}

function showFormElementStart2(&$render,$action,$method="post",$class="",$id="",$target=false) {
	/* method=get gives wrong behaviour if actionAndViewURL has arguments in it,
	 * since they'll be deleted in favour of the form's fields 
	 * (at least under netscape ) */
	$classAtt = ($class!="")?"class=\"$class\"":"";
	if ($id!="") {
		$classAtt .= " id=\"$id\"";
	}
	$render->show("<form $classAtt action=\"$action\" method=\"$method\"".($target?" target=\"$target\"":"").">");
	$render->show('<div><!-- form -->');
}

function showFormElementStartRPC(&$render,$class="",$id="") {
	showFormElementStart2($render,'rpc.php','get',$class,$id,"RSIFrame");
}

function showButton(&$render,$name,$label,$tabindex='') {
	$render->show(
		'<input type="submit" '.
		(($name!="")?" name=\"$name\" ":"").
		'value="' . $label . '"'.
		($tabindex!=''?" tabindex=\"$tabindex\"":"").'>');
}

function showFormElementEnd(&$render,$label="",$name="",$tabindex="") {
	if ($label!="") 
		$render->show('<input type="submit" '.
					  (($name!="")?" name=\"$name\" ":"").
					  'value="' . $label . '"'.
					  ($tabindex!=''?" tabindex=\"$tabindex\"":"").'>');
	$render->show('</div><!-- form -->');
	$render->show('</form>');     /* Netscape rendering bug prohibits </p> */
}

/* show action form element */
function showFormElementAction(&$render,$action) {
	$render->show("<input type=\"hidden\" name=\"action\" value=\"$action\">");
}

function showFormElementHidden(&$render,$name,$value="") {
	$render->show("<input type=\"hidden\" name=\"$name\" value=\"$value\">");
}


function showFormElementFile(&$render,$name,$accept="") {
	$render->show('<input name="'.$name.'" type="file" size="40"'.
				  ($accept?" accept=\"$accept\"":"")."><br>");
}

function showFormElementDescriptionTextArea(&$render,$description = "") {
	$render->show(_("Description:")."<br>");
	$render->show("<textarea rows=\"4\" cols=\"40\" " . " name=\"Description\">" .
				  $description . "</textarea><br>");
}

function showFormElementTextArea(&$render,$name,$label,$value='') {
	if ($label)
		$render->show($label.'<br>');
	$render->show("<textarea rows=\"4\" cols=\"40\" " . " name=\"$name\">$value</textarea><br>");
}

/* HTML <select> item generator */
function showFormElementSelect(&$render,$name,$items,$selected="") {
	$render->show('<select name="'.$name.'">');
	reset($items);
	while (list($value,$text)=each($items)) {
		if ($value == $selected) {
			$render->show('<option value="'.$value.'" selected>'.$text.'</option>');
		} else {
			$render->show('<option value="'.$value.'">'.$text.'</option>');
		}
	}
	$render->show("</select>");
}

/** show text entry input */
function showFormElementInteger(&$render,$name, $value, $size=3, $newline=true) {
	$render->show(
		"<input type=\"text\" value=\"$value\" size=$size name=\"$name\">".
		($newline?"<br>":""));
}

function showFormField(&$render,$name, $label, $value=false, $comment='', $size=20) {
	$render->show(
		"<label ".($comment?" title=\"$comment\"":'').">".
		$label.': '.
		"<input type=\"text\" value=\"$value\" size=$size name=\"$name\"></label><br>");
}

/**
 * @param name name of the field
 * @param label text to display next to the field
 * @param value initial value of the boolean field
 */
function showFormBooleanField(&$render,$name,$label,$value=false,$comment='') {
	showFormElementHidden($render,$name,0); // So we can now if it's unchecked
	showFormElementCheckBox(
		$render,
		$name,
		$value=='t' || $value=='true' || $value===true,
		"$label<br>",
		'true','cb',$comment);
}

function showFormElementCheckBox(
	&$render,$name,$checked=false,$text,$value='true',
	$class="cb",$comment='') 
{
	$render->show('<label'.($class?" class=\"$class\"":'').($comment?" title=\"$comment\"":'').'>'.
				'<input name="'.$name.'" type="checkbox" value="'.$value.'"'.
				($checked?' checked':'').'><span>'.$text.'</span></label>');
}

function showFormElementRadioButton(&$render,$name,$value,$text,$checked=false) {
	$render->show('<label class="radio">'.
				'<input name="'.$name.'" type="radio" value="'.$value.'"'.
				($checked?' checked':'').'>'.$text.'</label>');
}

function showFormElementAuthor(&$render, $owner, $label) {
	$users = $render->ct->getAll('users','*','Name');
	$render->show($label);
	$render->show('<select name="Owner">');
	reset($users);
	while (list($key, $user) = each($users)) {
		$render->show("<option value=\"" . $user['UserID'] . "\"" . 
					(($user['UserID'] == $owner) ? " selected" : "") .
					">" . $user['Name'] . "</option>");
	}
	$render->show('</select><br>');
}

function showFormElementParentTopicID(
	&$render,
	$parentTopicID = "",
	$maybeunchanged = false, 
	$excludeTopic = "",
	$id = "",
	$maybenew = false) 
{
	if ($id!="")
		$id = ' id="'.$id.'"';
	$render->show(_('Parent album:').'<br>');
	$render->show("<select name=\"ParentTopicID\"$id>");
	if ($maybeunchanged) {
		$render->show('<option value="unchanged"'.
					($parentTopicID ? '' : ' selected').
					'>'.
					_('Unchanged').
					'</option>');
	}
	$topics = $render->getAllTopics();
	foreach($topics as $topic) {
		if ($topic['TopicID']!=$excludeTopic) {
			$render->show(
				"<option value=\"" . $topic['TopicID'] . "\"" . 
				(($topic['TopicID'] == $parentTopicID) ? " selected" : "") .
				">" . $topic['Description'] . '</option>');
		}
	}
	$render->show('</select><br>');

	if ($maybenew) {
		$render->show(_("New topic:"));
		$render->show(
			"<input type=\"text\" size=\"48\" name=\"NewTopicDescription\" value=\"\" id=\"topicDesc\"><br>");
	}
}

/* Show text entry input */
function showFormElementText(&$render,$text,$name,$size=32,$newline = true,$value="") {
	if ($text)
		$render->show("$text : ",false);
	$render->show("<input type=\"text\" size=$size name=\"$name\" value=\"$value\">".
				  ($newline?"<br>":""));
}

function showFormElementSize(&$render,$prefix,$value) {
	$units = array(0=>_('bytes'),
				   1=>_('Kb'),
				   2=>_('Mb'),
				   3=>_('Gb'),
				   4=>_('Tb'));
	if (isset($value) && $value!=='') {
		list($value,$unit) = makeSize($value);
		$value = ' value="'.$value.'"';
	} else {
		$value = '';
		$unit = 0;
	}
	$render->show('<input name="'.$prefix.'Size" type="text"'.$value.' size="5">');
	showFormElementSelect($render,$prefix.'Unit',$units,$unit);
}
?>