<?php
/**
 * show GroupID form element 
 * @param pictureID initialize with groups of this picture
 * @param maybeunchanged if true, add an "unchanged" value
 */
function showFormElementGroupSelector(&$render,$pictureID = "",$maybeunchanged=false) {
	if ($pictureID) {
		$pictureGroups = $render->ct->getGroupsForPicture($pictureID);
	} else {
		$pictureGroups = array();
	}
	if ($maybeunchanged) {
		$render->show(
			'<input type="checkbox" value="unchanged"'.
			($pictureID ? '' : ' checked').
			'>'._('Unchanged'));
	}

	$render->show('<div class="groupsel">');
	$render->show(_('Groups:').'<br>');
	$render->show('<select name="Groups[]" size="6" multiple>');
	$groups = $render->ct->getRealGroups();
	foreach ($groups as $group) {
		$render->show('<option value="' . $group['GroupID'] . '"' . 
					($pictureGroups[$group['GroupID']] ? " selected" : "") .
					'>' . $group['Name'] . '</option>');
	}
	$render->show('</select><br>');
	$render->show('</div>');

	$render->show('<div class="usersel">');
	$render->show(_('Users:').'<br>');
	$render->show('<select name="Groups[]" size="6" multiple>');
	$groups = $render->ct->getIndividualGroups();
	foreach ($groups as $group) {
		$render->show('<option value="' . $group['GroupID'] . '"' . 
					($pictureGroups[$group['GroupID']] ? " selected" : "") .
					'>' . $group['Name'] . '</option>');
	}
	$render->show('</select><br>');
	$render->show('</div><hr class="transpa">');
}

function showFormUpdateGroup(&$render,$groupID,$users) {
	require_once("render/form_elements.php");
	$render->show("<h2>"._("Update group")."</h2>");
	showFormElementStart($render);
	showFormElementGroupID($render,$groupID);
	showFormElementGroupName($render,$groupID);
	showFormElementGroupUsers($render,$groupID,$users);
	showFormElementAction($render,"updateGroup");
	showFormElementEnd($render,_("Update group"));
}
  
function showFormDeleteGroup(&$render,$groupID) {
	require_once("render/form_elements.php");
	$render->show("<h2>"._("Delete group")."</h2>");
	$render->setView(array("MyGroups"=>""),true);
	showFormElementStart($render);
	showFormElementGroupID($render,$groupID);
	showFormElementAction($render,"deleteGroup");
	showFormElementEnd($render,_("Delete"));
}
  
function showFormAddUserToGroup(&$render,$groupID) {
	require_once("render/form_elements.php");
	$render->show("<h2>"._("Add user to group")."</h2>");
	showFormElementStart($render);
	showFormElementGroupID($render,$groupID);
	showFormElementPickUser($render);
	showFormElementAction($render,"addUserInGroup");
	showFormElementEnd($render,_("Add user to group"));
}

/* private: show a form to add a roll */
function showFormAddGroup(&$render) {
	$render->show('<div class="form" id="formAddGroup">');
	$render->show("<h2>"._("Add group")."</h2>");
	_showFormAddGroup($render);
	$render->show('</div>');
}

/* private: show a form to add a roll */
function _showFormAddGroup(&$render) {
	require_once("render/form_elements.php");
	showFormElementStart($render);
	showFormElementGroupID($render);
	showFormElementGroupUsers($render);
	showFormElementAction($render,"addGroup");
	showFormElementEnd($render,_("Add"));
}

function showFormElementGroupID(&$render,$groupID = "") {
	if ($groupID != "") {
		$render->show("<input type=\"hidden\" name=\"GroupID\" value=\"$groupID\">");
	} else {
		$render->show(_('Group name:').'<br>');
		$render->show('<input type="text" name="groupName"><br>');
	}
}

function showFormElementGroupName(&$render,$groupID = '') {
	$render->show(_('Group name:').'<br>');
	$group = $render->ct->getGroup($groupID);
	$render->show(
		'<input type="text" name="groupName" value="'.$group['Name'].'"><br>');
}

function showFormElementGroupUsers(&$render,$groupID=null,$groupUsers=array(),$size=10) {
	$render->show(_("Users:")."<br>");
	$render->show("<select size=\"$size\" name=\"groupUsers[]\" multiple>");
	$users = $render->ct->getUsers();
	reset($users);
	while( list($key, $user) = each($users) ) {
		$render->show(
			"<option value=\"". $user['UserID'] . "\""
			. ( $render->slooze->findUser($groupUsers,$user['UserID']) ? " selected " : "" )
			.">". $user['Name'] 
			."</option>");
	}
	$render->show("</select><br>");
}
?>