<?php
/* Updates selected pictures in a roll */
function showFormUpdatePictures(&$render,$rollID,$pictures=NULL) {
	require_once("render/form_group.php");
	$render->show('<div class="form" id="formUpdatePictures">');
	$render->show('<h2>'._('Update group and album for selected pictures').'</h2>');
	showFormElementStart($render);
	showFormElementRollID($render,$rollID);
	$render->show(_('Please select the pictures that you want to update:').'<br>');
	showFormElementPicturesSelector($render,$rollID,$pictures);
	showFormElementParentTopicID($render,"",true);
	$render->show('<fieldset><legend>'._('Groups').'</legend>');
	showFormElementGroupSelector($render,"",true);
	$render->show('</fieldset>');
	showFormElementAction($render,"updatePictures");
	showFormElementEnd($render,_("Update"));
	$render->show('</div>');
}

/* Add keyword for selected pictures in a roll */
function showFormAddKeywords(&$render,$rollID,$pictures=NULL) {
	require_once("render/form_keyword.php");
	$render->show('<div id="formAddKeywords">');
	$render->show("<h2>"._("Add keyword for selected pictures")."</h2>");
	showFormElementStart($render);
	showFormElementRollID($render,$rollID);
	showFormElementPicturesSelector($render,$rollID,$pictures);
	showFormElementTypeSelector($render);
	showFormElementKeywordvalue($render);
	showFormElementAction($render,"addKeywords");
	showFormElementEnd($render,_("Add keyword"));
	$render->show("</div>");
}

function showFormElementPicturesSelector(&$render,$rollID,$pictures=NULL) {
	if ($pictures==NULL)
		list($count,$pictures) = 
			$render->ct->getPicturesInRoll(
				$rollID, $render->uid,
				array('pictures.PictureID','pictures.FrameID'));
	else
		$count = count($pictures);
	$render->show("<select size=\"".min(10,$count)."\" name=\"Pictures[]\" multiple>");
	foreach($pictures as $picture) {
		$render->show("<option value=\"" . $picture['PictureID'] . "\">" . 
					$picture['FrameID'] ."</option>");
	}
	$render->show("</select><br>");
}

function renderAddPicture(&$render) {
	$render->setView(array('form'=>'addImage'),true);
	$render->setBareTitle(_("Add picture"));
	_showFormAddPicture($render);
}

/* private: show a form to add a picture */
function showFormAddPicture(&$render,$rollID) {
	$render->show('<div class="form" id="formAddPicture">');
	$render->show('<h2>'._('Add picture').'</h2>');
	_showFormAddPicture($render,$rollID);
	$render->show('</div>');
}

function _showFormAddPicture(&$render,$rollID="") {
	require_once("render/upload.php");
	showFormElementStart($render);
	showFormElementRollID($render,$rollID);
	showFormElementFrameID($render);
	showFormElementParentTopicID($render);
	showFormElementDescriptionTextArea($render);
	showFormElementAction($render,"addPicture");
	showFormElementEnd($render,_("Add"));
}

/* private: show a form to add all pictures in a roll */
function showFormAddAllPictures(&$render,$rollID) {
	$render->show('<div id="formAddAllPictures">');
	$render->show("<h2>"._("Add all pictures")."</h2>");
	showFormElementStart($render);
	showFormElementRollID($render,$rollID);
	showFormElementParentTopicID($render);
	showFormElementGroupSelector($render);
	showFormElementAction($render,"addAllPictures");
	showFormElementEnd($render,_("Add all pictures"));
	$render->show("</div>");
}

/* private: show a form to update a roll */
function showFormUpdateRoll(&$render,$rollID) {
	require_once("render/form_elements.php");
	$render->show('<div class="form" id="formUpdateRoll">');
	$render->show("<h2>"._("Update roll")."</h2>");
	showFormElementStart($render);
	showFormElementRollID($render,$rollID);
	showFormElementAction($render,"updateRoll");
	showFormElementEnd($render,_("Update"));
	$render->show('</div>');
}

/* private: show a form to delete a roll */
function showFormDeleteRoll(&$render,$rollID) {
	require_once("render/form_elements.php");
	$render->show('<div class="form" id="formDeleteRoll">');
	$render->show("<h2>"._("Delete roll")."</h2>");
	showFormElementStart($render);
	showFormElementRollID($render,$rollID);
	showFormElementAction($render,"deleteRoll");
	showFormElementEnd($render,_("Delete"));
	$render->show('</div>');
}

/* private: show a form to add a roll */
function showFormAddRoll(&$render) {
	require_once("render/form_elements.php");
	require_once("render/form_group.php");
	$render->show('<div class="form" id="formAddRoll">');
	$render->show("<h2>"._("Add roll")."</h2>");
	showFormElementStart($render);
	showFormElementRollID($render,'',$render->user['Username'].' / ');
	showFormBooleanField($render,"addAllPictures",_("Add all pictures"),false);
	showFormElementParentTopicID($render);
	showFormElementGroupSelector($render);
	showFormElementAction($render,"addRoll");
	showFormElementEnd($render,_("Add"));
	$render->show('</div>');
}

/* Show RollID form element */
function showFormElementRollID(&$render, $rollID = '', $prepend='') {
	if ($rollID != "") {
		$render->show("<input type=\"hidden\" name=\"RollID\" value=\"$rollID\">");
	}
	else {
		$render->show(_('RollID:').'<br>');
		$render->show("$prepend<input type=\"text\" name=\"RollID\" ><br>");
	}
}
?>