<?php
/* information to show at the top of the page */
function showTop(&$render) {
	$render->show('<div id="mytop">');
	showUserBar($render);
	showTitleBar($render);
	$render->show('</div>');
}

/* display the small gray bar at the top of pages */
function showUserBar(&$render) {
	$querystring = $render->view;
	if ($querystring!="") {
		$querystring = "?" . $querystring;
	}
	$render->show('<div class="userinfo" id="userinfo" ondblclick="showHide()">');
	if (!$render->anonymous) {
		/*
		  $render->show(" | <a href=\"".$render->actionAndViewURL("again=yes")."\">".
		  _("login")."</a>");
		*/
		$render->show("<a href=\"".$render->actionAndViewURL("logout=yes")."\">".
					_("logout")."</a>");
		if ($render->admin && ($render->user['Upload'] || $render->uid==1)) {
			$render->show(" | <a href=\"".$render->selfURL("Topics=t")."\">".
						_("albums")."</a>");
			$render->show(" | <a href=\"".$render->selfURL("MyRolls=t")."\">".
						_("my rolls")."</a>");
			$render->show(" | <a href=\"".$render->selfURL("MyGroups=t")."\">".
						_("my groups")."</a>");
			$render->show(" | <a href=\"".$render->selfURL("form=upload")."\">".
						_("upload pictures")."</a>");
			if ($render->isAdmin)
				$render->show(" | <a href=\"".$render->selfURL("Users=t")."\">".
							_("users")."</a>");
		}
	} else {
		$render->show("<a href=\"".$render->actionAndViewURL("again=yes")."\">".
					_("login")."</a>");
	}
	if (!$render->admin) {
		$render->show(" | <a href=\"".$render->selfURL("Searchs=t")."\">"
					._("search")."</a>");
		$render->show(" | <a href=\"".$render->selfURL("RateSort=t")."\">"
					._("best pictures")."</a>");
		$render->show(" | <a href=\"".$render->selfURL("DateSort=t")."\">"
					._("latest pictures")."</a>");
		$render->show(" | <a href=\"".$render->selfURL("Unindexed=t")."\">"
					._("unindexed pictures")."</a>");
		$render->show(" | <a href=\"".$render->selfURL("Unrated=t")."\">"
					._("unrated pictures")."</a>");
	}
	$render->show(" | <a href=\"".$render->actionAndViewURL("displayPrefs")."\">".
				  _("preferences")."</a>");
	if (!$render->anonymous) {
		if ($render->canSelect)
			$render->show(" | <a href=\"".$render->selfURL("Selected=t")."\">"
						._("selected pictures")."</a>");
		if ($render->admin) {
			$render->show(" | <a href=\"photos.php$querystring\">"
						._("normal view")."</a>");
		} else if ($render->user['Upload'] || $render->uid==1) {
			$render->show(" | <a href=\"admin.php$querystring\">"
						._("admin view")."</a>");
		} 
	}
	$render->show("</div>");
}
  
/* show the head of the page */
function showTitleBar(&$render) {
	$render->show('<div class="header" id="header">');
	$render->show('<h1 class="header">'.$render->topTitle.'</h1>');
	if ($render->showSort || $render->showMode || $render->showNbThumbs) {
		require_once("render/form_displayprefs.php");
		showFormDisplayPrefs(
			$render,
			$render->showSort?$render->slooze->ct->sortMethod:nil,
			$render->showMode?$render->displayMode:nil,
			$render->showNbThumbs?$render->nbThumbsPerPage:nil,
			$render->showRecursiveTopic);
	}
	$render->show('</div>');
}

function countString(&$render,$start,$count) {
	if ($count==0)
		return "";
	else
		return " [".($start+1)."-".min($start+$render->nbThumbsPerPage,$count)
			."/$count]";
}
?>