<?php
/** Render a page body for a given picture */
function renderPicture(&$render,$pictureID) {
	$render->setSelection(array('PictureID'=>$pictureID));
	$render->setView(array('PictureID'=>$pictureID));
	$picture = $render->ct->getPicture($pictureID, $render->uid);
	if ($picture) {
		_renderPicture($render,$picture);
	} else {
		require_once("render/navbar.php");
		showNavBar($render);
		$render->error(_("Picture not found : ").$pictureID);
	}
}

function _renderPicture(&$render,$picture, $prev=false, $next=false, $position=0, $last=-1) {
	require_once("render/navbar.php");
	require_once("render/nav.php");
	require_once("render/format_date.php");
	$pictureID = $picture['PictureID'];

	if (!$render->admin)
		$render->ct->clickPicture($pictureID);

	if (isset($picture['Description']) && $picture['Description'] != "") {
		$render->htmlTitle = $picture['Description'];
	} else {
		$render->htmlTitle = _("untitled");
	}
	$owner = $render->ct->getUser($picture['Owner']);
	$render->show('<div class="normal">');
	$render->show('<div class="picture">');
	showPicture($render,$picture);
	$render->show('<p class="copyright">&copy; '.$owner['Name'].'<br>'.
				formatDate($picture['Date']).'</p>');
	$render->show('</div>');
	$render->show('</div>');

	showPrevNext($render,$prev,$next,$position,$last);

	$render->show('<div class="normal">');
	$topics = $render->ct->getTopics($pictureID,$render->uid);
	showNavs($render,$topics);
	if ($render->displayMode == 'detail') {
		require_once("render/form_picture.php");
		require_once("render/link.php");
		showFormSimilarPictures($render,$pictureID);
		showFormRatePicture($render,$pictureID);
		showRate($render,$picture);
		$render->show('<hr class="transpa">');
		showFormAddKeyword($render,$picture);
		showKeywords($render,$pictureID);
		$render->show('<hr class="transpa">');
		if ($render->slooze->adminComments) {
			showFormAddComment($render,$pictureID);
		}
		showComments($render,$render->ct->getCommentsInPicture($pictureID));
		$render->show('<hr class="transpa">');
		if (!$render->anonymous) {
			showPictureGroups($render,$pictureID);
		}
		showRollLink($render,$picture);
	}
	if ($render->admin && $render->displayMode!='diaporama') {
		require_once("render/form_picture.php");
		$topicIDs = array();
		foreach($topics as $topic) {
			$topicIDs[] = $topic['TopicID'];
		}
		showFormUpdatePicture($render,$picture,$topicIDs);
		if ($render->admin) {
			showFrontPages($render,$pictureID);
			showFormAddToFrontPage($render,$picture,$render->getParentTopics($topics));
		}
		if ($render->uid == $picture['Owner']) {
			showFormDeletePicture($render,$picture);
		}
	}
	$render->show('</div>');
}

/** Show a single full-size picture */
function showPicture(&$render,$picture) {
	if (is_array($picture) && count($picture) > 0) {  
		require_once("render/tooltip.php");
		/* make img tag with size and caption */
		if ($picture['Description'] != "") {
			$render->show('<p class="desc">'.$picture['Description'].'</p>');
		}
		$fileName = $render->slooze->getPictureFilename($picture);
		$size = GetImageSize($fileName);
		$prefSize = $render->user['PictureSize'];
		if ($prefSize && ereg("([0-9]+)x([0-9]+)",$prefSize,$res)) {
			$prefSize = array(0=>$res[1],1=>$res[2]);
			$size = resize(array(0=>$size[0],1=>$size[1]),$prefSize);
		}
		$sizeStr = ' width="'.$size[0].'" height="'.$size[1].'"';
		$tooltip = getToolTip($render,$picture);
		$hasOrig = file_exists($render->slooze->getOrigFilename($picture));
		$render->show('<p class="picture">');
		if ($hasOrig)
			$render->show(
				'<a href="'.
				$render->url("picture.php?PictureID=".$picture['PictureID']).'&amp;Size=full">');
		$render->show('<img src="'.
					$render->url("picture.php?PictureID=".$picture['PictureID'].
							   "$DontCountClick").'&amp;Size=medium"'.
					$sizeStr.
					' alt="'.$picture['Description'].'" '.$tooltip.'>');
		if ($hasOrig)
			$render->show('</a>');
		$render->show('</p>');
	}
}

/* private: show ratings for a picture */
function showRate(&$render,$picture) {
	if ($picture['NbRates']>0) {
		$render->show('<h2>'._('Ratings').'</h2>');
		$render->show('<p>'._('Average:').round(100 * $picture['AverageRate']) / 100 .', '.
					  _('Count:').$picture['NbRates'].', '.
					  _('Max:').$picture['MaxRate'].', '.
					  _('Min:').$picture['MinRate'].'</p>');
	} else {
		$render->show('<h2>'._('No ratings for this picture').'</h2>');
	}
}

function showKeywords(&$render,$pictureID) {
	$render->show("<h2>"._("Keywords")."</h2>");
	$render->show('<ul id="keywords'.$pictureID.'">');
	$keywords = $render->ct->getTypedKeywords($pictureID);
	$count = 0;
	foreach($keywords as $keyword) {
		$id = 'k'.$count++;
		showKeywordItem($render,$pictureID,$keyword,$id);
	}
	$keywords = $render->ct->getUntypedKeywords($pictureID);
	foreach($keywords as $keyword) {
		$id = 'k'.$count++;
		showKeywordItem($render,$pictureID,$keyword,$id);
	}
	$render->show("</ul>");
}

function showKeywordItem(&$render,$pictureID,$keyword,$id) {
	require_once("render/actions.php");
	$render->show(
		"<li id=\"$id\">" . 
		($keyword['Type']!=0 ? $keyword['Libelle_fr'] . " = " : "").
		"<a href=\"".$render->selfURL(
			"TypeID=".$keyword['Type'].$render->output_separator.
			"Keyword=".rawurlencode($keyword['Value']))."\">" .
		$keyword['Value'] . "</a>");
	if ($render->admin)
		showIconRPC(
			$render,
			"delete.png",
			_('remove'),
			"removeKeyword",
			array('PictureID' => $pictureID,
				  'TypeID' => $keyword['Type'],
				  'KeywordValue' => $keyword['Value'],
				  '_RemoveID' => $id));
}

/* private: show all comments in $comments */
function showComments(&$render,$comments) {
	$render->show('<h2>'._('Comments').'</h2>');
	if (is_array($comments) && count($comments) > 0) {
		reset($comments);
		while( list($key, $comment) = each($comments)) {
			$render->showComment($comment);
		}
	}
}

/* private: show a single comment */
function showComment(&$render,$comment) {
	if (is_array($comment) && count($comment) > 0) {
		$render->show('<p class="comment">');
		// show IP of commenter if it exists, and we're in admin mode
		if ( ($render->admin || $render->showCommentIPs) && strlen($comment['IP']) )
			$render->show('('. $comment['IP'] . ') ');
		if ($comment['UserID'] != 0) {
			$user = $render->ct->getUser($comment['UserID']);
		} else {
			$user['Name'] = 'Anonyme';
		}
		$render->show('[' . $user['Name'] . '] : ');
		$render->show($comment['Comment'] . '</p>');
		if ($render->admin) {
			$render->showFormDeleteComment($comment['CommentID']);
		}
	}
}

function showPictureGroups(&$render,$pictureID) {
	require_once("render/actions.php");
	$render->show("<h2>"._("Groups")."</h2>");
	$groups = $render->ct->getGroupsForPicture($pictureID);
	if (is_array($groups)) {
		$render->show("<ul>");
		reset($groups);
		while( list($key, $group) = each($groups)) {
			$id = '';
			$remove = '';
			if ($render->admin)
				$id = " id=\"g${group['GroupID']}\"";
			$render->show("<li$id>".$group['Name'],false);
			if ($render->admin)
				showIconRPC(
					$render,
					'delete.png',
					_('remove'),
					'removeGroupsFromPicture',
					array('_Pictures[]' => $pictureID,
						  '_Groups[]' => $group['GroupID'],
						  '_RemoveID' => 'g'.$group['GroupID']));
			$render->show("</li>");
		}
		$render->show("</ul>");
	}
}

function showFrontPages(&$render,$pictureID) {
	require_once("render/actions.php");
	require_once("render/nav.php");
	$render->show('<h2>'._('Front pages').'</h2>');
	$topics = $render->ct->getPictureFrontPages($pictureID);
	$render->show('<ul class="frontpages" id="frontpages'.$pictureID.'">');
	foreach($topics as $topic) {
		$id = 'fp'.$topic['TopicID'];
		$render->show('<li id="'.$id.'">',false);
		showNav($render,$topic['TopicID']);
		showIconRPC(
			$render,
			'delete.png',
			_('remove'),
			'removeFromFrontPage',
			array('_TopicID' => $topic['TopicID'],
				  '_PictureID' => $pictureID,
				  '_RemoveID' => $id));
		$render->show('</li>');
	}
	$render->show('</ul>');
}

function resize($orig,$new) {
	$scales = array();
	for($i=0; $i<sizeof($orig); $i++) {
		$scales[$i] = $new[$i] / $orig[$i];
	}
	$scale = min($scales);
	for($i=0; $i<sizeof($orig); $i++) {
		$new[$i] = $orig[$i] * $scale;
	}
	return $new;
}

?>