<?php
function renderDisplayPrefsForm(&$render) {
	require_once("render/html.php");
	$render->onload = "";

	$render->setTitle(_('Preferences'));
	$render->setNoDisplayPrefs();

	include("render/form_elements.php");

	if (!$render->anonymous) {
		require_once("render/user.php");
		showFormUserPrefs($render,$render->user);
	}

	h2($render,_('Display preferences'));
	showFormElementStart2($render,$render->filterSelfUrl('displayPrefs'));
	showFormField(
		$render,'ThumbScale',
		_('Thumbnails scaling'),
		$render->thumbScale);
	showFormField(
		$render,'PageScale',
		_('Page scaling'),
		$render->pageScale);
	showFormField(
		$render,'PictureSize',
		_('Picture size (width&times;height)'),
		$render->pictureSize,
		_('Maximum displayed picture dimensions.'),
		10);
	showFormField(
		$render,'PictureInterval',
		_('Interval between pictures (seconds)'),
		$render->pictureInterval,
		_('Number of seconds to wait between each picture in slideshow mode.'),
		5);

	showFormBooleanField(
		$render,
		'ShowEmptyTopics',
		_('Show empty albums'),
		$render->showEmptyTopics);
	showFormBooleanField(
		$render,'ShowThumbCB',
		_('Show selection check box below thumbnails'),
		$render->showThumbCB,
		_('You will still be able to select a picture by double-clicking on the description below the thumbnail even if the checkbox is not displayed.'));
	showFormBooleanField(
		$render,'ShowThumbTitle',
		_('Show title below thumbnails'),
		$render->showThumbTitle);
	showFormBooleanField(
		$render,'ShowThumbDate',
		_('Show date below thumbnails'),
		$render->showThumbDate);
	showFormBooleanField(
		$render,'ShowTooltips',
		_('Use tooltips on pictures'),
		$render->showTooltips);
	
	showFormElementAction($render,'updateDisplayPrefs');
	showFormElementEnd($render,_('Update'));

	showFormElementStart2($render,$render->filterSelfUrl('displayPrefs'));
	showFormElementEnd($render,_('Cancel'));
}
?>