<?php
function renderSelected(&$render,$start) {
	require_once("render/thumb.php");
	require_once("render/header.php");
	$render->setSelection(array('Selected'=>'t'),true);
	$render->setView(array('Selected'=>'t',
						   'Start'=>$start),true);
	list($count,$pictures) = 
		$render->ct->getSelectedPictures(
			$render->uid,$start,
			$render->nbThumbsPerPage);
	$render->setTitle(_('Selected pictures'));
	$render->topTitle .= " ".countString($render,$start,$count);
	$render->show('<div class="normal">');
	showThumbs($render,$pictures,$start,$count);

	if ($count>0) {
		require_once("render/form_keyword.php");
		require_once("actions/file_size.php");

		showFormElementStart($render);
		showFormElementAction($render,'clearSelection');
		showFormElementEnd($render,_('Clear selection'));

		list($count,$pictures) = $render->ct->getSelectedPictures($render->uid);

		$sizes = getFileSizes($render->slooze,$pictures);
		$render->show('<h2>'._('Export selection').'</h2>');
		showFormElementStart($render);
		showFormBooleanField($render,
			'ExportThumb',
			_('export thumbnails').' ('.makeSizeString($sizes['thumb']).')',
			true);

		showFormBooleanField($render,
			'ExportNormal',
			_('export normal size pictures').' ('.makeSizeString($sizes['normal']).')',
			true);

		showFormBooleanField($render,
			'ExportFullSize',
			_('export full size pictures').' ('. makeSizeString($sizes['fullsize']).')',
			false);

		showFormElementAction($render,'exportSelection');
		showFormElementEnd($render,_('Export'));

		if ($render->user['Upload']) {
			require_once("render/form_topic.php");
			require_once("render/form_group.php");
			$render->show('<h2>'._('Change the albums of selected pictures').'</h2>');
			showFormElementStartRPC($render);
			showFormElementRadioButton($render,'TopicAction','add',_('add'),true);
			showFormElementRadioButton($render,'TopicAction','set',_('replace'),false);
			showFormElementRadioButton($render,'TopicAction','remove',_('remove'),false);
			$render->show("<br>");
			showFormElementTopicTree($render,'',array());
			showFormElementAction($render,'changeSelectionTopics');
			showFormElementEnd($render,_('Change albums'));
			$render->show('<h2>'._('Change the groups of selected pictures').'</h2>');
			showFormElementStartRPC($render);
			showFormElementRadioButton($render,'GroupAction','add',_('add'),true);
			showFormElementRadioButton($render,'GroupAction','set',_('replace'),false);
			showFormElementRadioButton($render,'GroupAction','remove',_('remove'),false);
			showFormElementGroupSelector($render);
			showFormElementAction($render,'setSelectionGroups');
			showFormElementEnd($render,_('Set groups'));
		}

		$render->show('<h2>'._('Add keywords to selected pictures').'</h2>');
		showFormElementStartRPC($render);
		showFormElementTypeSelector($render);
		showFormElementKeywordvalue($render);	  
		showFormElementAction($render,'addKeywordsToSelection');
		showFormElementEnd($render,_('Add keywords'));

		if ($render->user['Upload']) {
			$render->show('<h2>'._('Rotate selected pictures').'</h2>');
			showFormElementStart($render);
			showFormElementHidden($render,'rotate','90');
			showFormElementAction($render,'rotateSelection');
			$render->show('<img src="rotate_cw.png">');
			showFormElementEnd($render,_('Rotate right'));

			showFormElementStart($render);
			showFormElementHidden($render,'rotate','270');
			showFormElementAction($render,'rotateSelection');
			$render->show('<img src="rotate_ccw.png">');
			showFormElementEnd($render,_('Rotate left'));
			  
			$render->show('<h2>'._('Update dates of selected pictures').'</h2>');
			showFormElementStartRPC($render);
			showFormBooleanField($render,'Overwrite',_('Overwrite current dates'),false);
			showFormElementAction($render,'updateSelectionDates');
			showFormElementEnd($render,_('Update dates'));


			$render->show('<h2>'._('Delete selected pictures').'</h2>');
			showFormElementStart($render);
			showFormBooleanField($render,'DeleteFiles',_('Delete files'),false);
			showFormElementAction($render,'deleteSelection');
			showFormElementEnd($render,_('Delete'));
		}
	} else {
		$render->show(_('Selection is empty'));
	}
	$render->show('<h2>'._('Add some pictures to the selection').'</h2>');
	$render->show('<p>'._('Enter the PictureID of the pictures in text area below.').'</p>');
	showFormElementStart($render);
	$render->show('<textarea name="Ids"></textarea><br>');
	showFormElementAction($render,'addToSelection');
	showFormElementEnd($render,_('Add'));	  
	$render->show('</div>');
}	
function showKeywordScript(&$render,$pictureID) {
	$render->show('<script type="text/javascript">');
	$topics = $render->ct->getTopics($pictureID,$render->uid);
	$keywords = array();
	foreach ($topics as $topic) {
		$keywords = array_merge($keywords,$render->ct->getTopicKeywordValues($topic['TopicID']));
		$keywords = array_unique($keywords);
	}
	$keywords = array_map("quote",$keywords);
	$render->show('var keywords = new Array(',false);
	$render->show(implode(",",$keywords),false);
	$render->show(');');
	$render->show('</script>');
	$render->show('<script src="keyword.js" type="text/javascript">');
}

function renderPictureInListSelected(&$render, $pictureID, $position) {
	require("render/picture.php");
	$render->setSelection(array('Selected'=>'t'),true);
	$render->setView(array('Selected'=>'t',
						   'PictureID'=>$pictureID,
						   'Position'=>$position),true);
	if ($pictures = $render->ct->getPictureInSelected($pictureID,$position,$render->uid)) {
		_renderPicture(
			$render,
			$pictures['current'], 
			$pictures['prev'], 
			$pictures['next'], 
			$position,
			$pictures['last']);
    }
}
?>