<?php
function renderSimilarPictures(&$render,$pictureID,$start=0) {
	require("render/thumb.php");
	require_once("render/header.php");
	$render->setSelection(array('SimilarPictures'=>$pictureID));
	$render->setView(array('SimilarPictures'=>$pictureID,
						 'Start'=>$start));
	$keywords = $render->ct->getKeywords($pictureID);
	reset($keywords);
	$values=array();
	while (list($key,$val)=each($keywords)) {
		$values[] = $val['value'];
	}
	list($count,$pictures) = 
		$render->ct->getMultipleKeywordSearch(
			$values,false,$render->uid,
			$start,$render->nbThumbsPerPage);
	$render->setTitle(_("Similar pictures"));
	$render->topTitle .= " ".countString($render,$start,$count);
	$render->show('<div class="normal">');
	showThumbs($render,$pictures,$start,$count);
	$render->show("</div>");
}

function renderPictureInSimilarPictures(&$render,$pictureID,$similarPictureID,$position) {
	require("render/picture.php");
	$render->setSelection(array('SimilarPictures'=>$similarPictureID));
	$render->setView(array('SimilarPictures'=>$similarPictureID,
						 'PictureID'=>$pictureID,
						 'Position'=>$position));
	$keywords = $render->ct->getKeywords($similarPictureID);
	reset($keywords);
	$values = array();
	while (list($key,$val)=each($keywords)) {
		$values[] = $val['value'];
	}
	if ($pictures = $render->ct->getPictureInMultipleKeywordSearch(
		$pictureID, $values, false,
		$position, $render->uid)) {
		_renderPicture(
			$render,
			$pictures['current'], 
			$pictures['prev'], 
			$pictures['next'], 
			$position,
			$pictures['last']);
	}
}
?>