<?php
/* Show a tree of all topics */
function renderTopics(&$render) {
	require_once("render/form_topic.php");
	require_once("render/navbar.php");
	$render->setView(array('Topics'=>''),true);
	$render->setNoDisplayPrefs();
	$render->setTitle(_("Albums"));
	$rootTopic = $render->ct->getTopic(0);
	$render->show('<div class="normal">');
	$render->show('<div class="forms">');
	showFormAddTopic($render,false);
	$render->show("</div>");
	$render->show(
		'<div class="help"><p>'.
		_('Double-click on an album name in the following tree to add a new subtopic in this album.').
		'</p></div>');
	$render->show('<div class="topics">');
	renderTopicsTree($render,getTopicsTree($render));
	$render->show("</div>");
	$render->show('</div>');
	showNavBar($render);
}

function getTopicsTree(&$render) {
	$topics = $render->getAllTopics();
	$root = NULL;
	$topicsByID = array();
	foreach($topics as $key => $topic) {
		$topicsByID[$topic['TopicID']] = &$topics[$key];
	}
	foreach($topicsByID as $topicID => $topic) {
		$topicsByID[$topic['ParentTopicID']]['SubTopics'][] = &$topicsByID[$topicID];
	}
	return $topicsByID[0];
}

function renderTopicsTree(&$render,&$topic) {
	//$subTopics = $render->ct->getSubTopics($topic['TopicID']);
	$subTopics = $topic['SubTopics'];
	$render->show('<span class="topic" ondblclick="addTopic('.$topic['TopicID'].')">'.
				$topic['Description'].'</span>');
	if (count($subTopics)>0) {
		$render->show('<ul class="topics">');
		foreach($subTopics as $subTopic) {
			$render->show('<li'.($subTopic['Book']?' class="book"':'').'>',false);			  
			renderTopicsTree($render,$subTopic);
			$render->show('</li>');			  
		}
		$render->show('</ul>');
	}
}
?>