<?php
require_once("render/form_elements.php");

function showFormElementStartUpload(&$render,$maxFileSize) {
	$render->show("<form enctype=\"multipart/form-data\" action=\"" . 
				  $render->actionAndViewURL() . "\" method=\"post\"><div>");
	$render->show("<input type=\"hidden\" name=\"MAX_FILE_SIZE\" ".
				  "value=\"$maxFileSize\">");
}

function showFormUpload(&$render,$limit)
{
	require_once("render/form_topic.php");
	require_once("render/form_group.php");

	$render->show('<div class="forms" id="formUploadImage">');
	showFormElementStartUpload($render,$limit);
	$render->show(_('Picture file:').'<br>');
	showFormElementFile($render,"file","image/jpeg");
	showFormElementRollIDMustExist($render);
	showFormElementFrameID($render);
	showFormElementParentTopicID($render,'',false,'','',true);
	showFormElementDescriptionTextArea($render);
	showFormElementGroupSelector($render);
	showFormElementAction($render,"upload");
	showFormElementEnd($render,_('Upload picture'));
	$render->show('</div>');
}

  /* private: show an upload form */
function showFormUploadArchive(&$render,$limit) 
{
	$render->show('<div class="forms" id="formUploadArchive">');
	showFormElementStartUpload($render,$limit);
	$render->show(_('Archive file (.tar or .zip) :').'<br>');
	showFormElementFile($render,"file","application/x-tar,application/zip");
	showFormElementRollIDMustExist($render);
	showFormElementParentTopicID($render,'',false,'','',true);
	showFormElementGroupSelector($render);
	showFormElementAction($render,'uploadArchive');
	showFormElementEnd($render,_('Upload archive'));
	$render->show('</div>');
}

function renderUploadForms(&$render) {
	$render->setView(array('form'=>'upload'),true);
	$render->setBareTitle(_('Picture uploading'));
	$render->show('<h2 class="tabHeader" id="h1">'._('Image upload').'</h2>');
	$render->show('<div class="tabPage" id="p1">');
	$render->show('<div class="help" id="helpUploadImage"><p>'.
				_('You can only upload jpeg images.').
				'</p><p>'.
				sprintf(_('The image file must not be bigger than %s.'),
						'<span style="white-space: nowrap">'.
						//number_format($slooze->uploadImageLimit,0,'.',_(',')).
						makeSizeString($render->slooze->uploadImageLimit).
						'</span>').
				'</p></div>');
	showFormUpload($render,$render->slooze->uploadImageLimit);
	$render->show('</div>'); // tabPage
	//$render->show('<hr>');

	$render->show('<h2 class="tabHeader" id="h2">'._('Image archive upload').'</h2>');
	$render->show('<div class="tabPage" id="p2">');
	$render->show(
		'<div class="help" id="helpUploadArchive">'.
		'<p>'.
		_('If you have more than one picture to upload, you can put them all in a tar or zip archive and upload the archive file here.').
		'</p><p>'.
		_('You should only put jpeg images in the archive. The frame ids will be the name of the file in the archive without the "jpeg" or "jpg" extension.').
		'</p><p>'.		  
		sprintf(_('The archive file must not be bigger than %s.'),
				'<span style="white-space: nowrap">'.
				//number_format($slooze->uploadArchiveLimit,0,'.',_(',')).
				makeSizeString($render->slooze->uploadArchiveLimit).
				'</span>').
		'</p></div>');
	showFormUploadArchive($render,$render->slooze->uploadArchiveLimit);
	$render->show('</div>'); // tabPage
	$render->showJavaScript(
		"var tabHeaders = new Array('h1','h2');".
		"var tabPages = new Array('p1','p2');".
		"//initTabs();");
}

function showFormElementRollIDMustExist(&$render,$rollID = "") {
	$allRolls = $render->ct->getRolls($render->uid);
	$render->show(_("RollID:")."<br>");
	$render->show("<select name=\"RollID\">");
	reset($allRolls);
	while (list($key, $value) = each($allRolls)) {
		$render->show("<option value=\"" . $value['RollID'] . "\"" . 
					  (($value['RollID'] == $rollID) ? " selected" : "") .
					  ">" . $value['RollID'] . "</option>");
	}
	$render->show("</select><br>");
	$render->show(_("New roll:"));
	$render->show('<input type="text" name="NewRollID"><br>');
}

function showFormElementFrameID(&$render,$frameID = "") {
	if ($frameID != "") {
		$render->show("<input type=\"hidden\" name=\"FrameID\"");
		$render->show("value=\"" . $frameID . "\" >");
	}
	else {
		$render->show(_("FrameID:")."<br>");
		$render->show("<input type=\"text\" name=\"FrameID\" ><br>");
	}
}
?>